/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationPlanContextInternal;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationPlanPrepareJob
implements Runnable,
Iterator<SimulationJob>,
SimulationJob.PostAction {
    private static final Log log = LogFactory.getLog(SimulationPlanPrepareJob.class);
    protected SimulationService simulationService;
    protected SimulationPlanContextInternal planContext;
    protected SimulationJob job;
    protected SimulationJob nextJob;
    protected boolean doNext = true;
    protected String id;
    protected SimulationControl control;
    protected SimulationParameter param;
    protected int done = 0;
    protected List<SimulationPlan> simulationPlan;

    public SimulationPlanPrepareJob(SimulationService simulationService, SimulationJob job) {
        this.simulationService = simulationService;
        this.job = job;
        this.id = job.getItem().getControl().getId();
        this.control = job.getItem().getControl();
        this.param = job.getItem().getParameter();
        this.simulationPlan = this.param.getSimulationPlans();
        this.planContext = new SimulationPlanContextInternal(this.control.getId(), this.param);
        try {
            for (SimulationPlan plan : this.simulationPlan) {
                plan.init(this.planContext);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.evaluate.preplan.script", (Object[])new Object[0]), (Throwable)eee);
            }
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.evaluate.preplan.script", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void run() {
        try {
            SimulationLoggerUtil.setPlanLoggingContext(this.id);
            this.runJob();
        }
        finally {
            SimulationLoggerUtil.clearPlanLoggingContext();
        }
    }

    public void runJob() {
        SimulationJob subJobN = null;
        if (this.hasNext()) {
            subJobN = this.next();
        }
        while (subJobN != null) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Simulation generated: " + subJobN.getId()));
                }
                SimulationItem itemN = subJobN.getItem();
                itemN.setStandaloneSimulation(false);
                itemN.setSimulationNumber(this.planContext.getNumber() - 1);
                SimulationJob subJobNp1 = this.next();
                if (subJobNp1 == null) {
                    itemN.setLastSimulation(true);
                }
                this.simulationService.submitSubJob(subJobN);
                subJobN = subJobNp1;
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)I18n.t((String)"Can't add simulation: %s", (Object[])new Object[]{this.job.getItem().getControl().getId()}), (Throwable)eee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        try {
            boolean result;
            boolean bl = result = !this.control.isStopSimulationRequest() && this.doNext;
            if (result) {
                SimulationPlanPrepareJob simulationPlanPrepareJob = this;
                synchronized (simulationPlanPrepareJob) {
                    if (this.nextJob == null) {
                        int planNumber = this.planContext.getNumber();
                        if (planNumber > 20000) {
                            log.error((Object)I18n.t((String)"Analyse plan error, too many simulation for %s : %s", (Object[])new Object[]{this.id, planNumber}));
                            this.doNext = false;
                            result = false;
                        } else {
                            String simId = this.id + "_" + planNumber;
                            this.param.setSimulationPlanNumber(planNumber);
                            File tmpDirectory = IsisFileUtil.createTempDirectory("isisfish-simulation-", "-preparation");
                            SimulationStorage sim = SimulationStorage.importAndRenameZip(tmpDirectory, this.job.getItem().getSimulationZip(), simId);
                            sim.getParameter().setSimulationPlanNumber(planNumber);
                            for (SimulationPlan plan : this.simulationPlan) {
                                if (result = result && plan.beforeSimulation(this.planContext, sim)) continue;
                                this.nextJob = null;
                                break;
                            }
                            this.doNext = result;
                            if (result) {
                                File zip = sim.createZip();
                                SimulationControl childControl = new SimulationControl(simId);
                                SimulationParameter childParam = this.param.copy();
                                SimulationItem item = new SimulationItem(childControl, childParam);
                                item.setSimulationZip(zip);
                                this.nextJob = new SimulationJob(this.simulationService, this.job, item, this.job.getPriority());
                                this.nextJob.setLauncher(this.job.getLauncher());
                                if (this.param.isIndependentPlan()) {
                                    this.nextJob.addPostAction(this);
                                }
                            }
                            sim.closeStorage();
                            sim.closeMemStorage();
                            if (!FileUtils.deleteQuietly((File)tmpDirectory)) {
                                log.warn((Object)I18n.t((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
                            }
                        }
                        this.planContext.incNumber();
                    }
                }
            }
            return result;
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.evalute.plan.script", (Object[])new Object[0]), eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimulationJob next() {
        SimulationJob result;
        this.hasNext();
        SimulationPlanPrepareJob simulationPlanPrepareJob = this;
        synchronized (simulationPlanPrepareJob) {
            result = this.nextJob;
            this.nextJob = null;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(SimulationJob job, SimulationStorage sim) {
        for (SimulationPlan plan : this.simulationPlan) {
            try {
                SimulationLoggerUtil.setPlanLoggingContext(this.id);
                boolean result = plan.afterSimulation(this.planContext, sim);
                this.doNext = this.doNext && result;
            }
            catch (Exception eee) {
                log.error((Object)I18n.t((String)"Stop simulation plan, because can't call afterSimulation correctly on plan %s", (Object[])new Object[]{plan.getClass().getName()}), (Throwable)eee);
                this.doNext = false;
            }
            finally {
                SimulationLoggerUtil.clearPlanLoggingContext();
            }
        }
        ++this.done;
        if (!this.hasNext() && this.done + 1 == this.planContext.getNumber()) {
            this.simulationService.fireStopEvent(this.job);
        }
    }

    @Override
    public void exception(SimulationJob job, Throwable eee) {
        this.doNext = false;
        this.simulationService.fireStopEvent(this.job);
    }
}

