/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import scripts.ResultName;
import scripts.SiMatrix;

public class Cantonnement
extends AbstractRule {
    private static Log log = LogFactory.getLog(Cantonnement.class);
    @Doc(value="Zone de fermeture")
    public Zone param_zone = null;
    @Doc(value="Engin concern\u00e9s")
    public Gear param_gear = null;
    @Doc(value="Begin step")
    public TimeStep param_beginStep = new TimeStep(0);
    @Doc(value="End step")
    public TimeStep param_endStep = new TimeStep(119);
    @Doc(value="Begin month")
    public Month param_beginMonth = Month.JANUARY;
    @Doc(value="End month")
    public Month param_endMonth = Month.DECEMBER;
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_NO_ACTIVITY};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Cantonnement: can be used to Cantonnement with gear if you put gear in parameter";
    }

    public void init(SimulationContext context) throws Exception {
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        boolean result;
        if (step.before(this.param_beginStep)) {
            return false;
        }
        if (step.after(this.param_endStep)) {
            return false;
        }
        if (step.getMonth().before(this.param_beginMonth)) {
            return false;
        }
        if (step.getMonth().after(this.param_endMonth)) {
            return false;
        }
        if (this.param_gear != null && !this.param_gear.equals(metier.getGear())) {
            return false;
        }
        List cellMetiers = metier.getMetierSeasonInfo(step.getMonth()).getCells();
        List cells = this.param_zone.getCell();
        cellMetiers.retainAll(cells);
        boolean bl = result = !Collections.disjoint(cellMetiers, cells);
        if (result && log.isInfoEnabled()) {
            log.info((Object)"Cantonnement condition true");
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        MetierMonitor metierMon = context.getMetierMonitor();
        MetierSeasonInfo infoMetier = metier.getMetierSeasonInfo(step.getMonth());
        List cellMetiers = infoMetier.getCells();
        List cells = this.param_zone.getCell();
        cellMetiers.removeAll(cells);
        if (cellMetiers.size() != 0) {
            ZoneDAO dao = IsisFishDAOHelper.getZoneDAO((TopiaContext)context.getDB());
            String name = "ZoneCantonnement-" + metier.getName() + "-" + step.getStep();
            Zone zoneCantonnement = dao.findByName(name);
            int cpt = 0;
            while (zoneCantonnement != null) {
                zoneCantonnement = dao.findByName(String.valueOf(name) + "-" + ++cpt);
            }
            zoneCantonnement = (Zone)dao.create(new Object[0]);
            if (cpt > 0) {
                name = String.valueOf(name) + "-" + cpt;
            }
            zoneCantonnement.setName(name);
            Collection zoneMetiers = infoMetier.getZone();
            Iterator i = zoneMetiers.iterator();
            while (i.hasNext()) {
                Zone zone = (Zone)i.next();
                ArrayList tmpCells = new ArrayList(zone.getCell());
                tmpCells.removeAll(this.param_zone.getCell());
                zoneCantonnement.addAllCell(tmpCells);
                i.remove();
            }
            ArrayList<Zone> newZone = new ArrayList<Zone>();
            newZone.add(zoneCantonnement);
            infoMetier.setZone(newZone);
        } else {
            SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
            MatrixND noActivity = metierMon.getOrCreateNoActivity(step, ResultName.MATRIX_NO_ACTIVITY, siMatrix.getStrategies(step), siMatrix.getMetiers(step));
            metierMon.addforbiddenMetier(metier);
            List<Strategy> strategies = siMatrix.getStrategies(step);
            for (Strategy str : strategies) {
                StrategyMonthInfo info = str.getStrategyMonthInfo(step.getMonth());
                double prop = info.getProportionMetier(metier);
                if (prop == 0.0) continue;
                noActivity.setValue((Object)str, (Object)metier, prop);
                info.setProportionMetier(metier, 0.0);
            }
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
    }
}

