/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.topia.persistence.pager.TopiaPagerBeanBuilder;

public abstract class AbstractJSONPaginedAction
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected TopiaPagerBean pager = new TopiaPagerBean();
    protected String sord;
    protected String sidx;
    protected String filters;
    protected String searchField;
    protected String searchString;
    protected String searchOper;

    public final Integer getRows() {
        return this.pager.getPageSize();
    }

    public final Integer getPage() {
        return this.pager.getPageIndex();
    }

    public final Long getTotal() {
        return this.pager.getPagesNumber();
    }

    public final Long getRecords() {
        return this.pager.getRecords();
    }

    public void setRows(Integer rows) {
        this.pager.setPageSize(rows.intValue());
    }

    public void setPage(Integer page) {
        this.pager.setPageIndex(page.intValue());
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchOper(String searchOper) {
        this.searchOper = searchOper;
    }

    protected String getSortColumn() {
        String result = null;
        if (this.useSort()) {
            result = this.sidx.equals("ID") ? "id" : this.sidx;
        }
        return result;
    }

    protected Boolean isSortAscendant() {
        Boolean result = null;
        if (this.useSort()) {
            result = "asc".equals(this.sord);
        }
        return result;
    }

    protected boolean useSort() {
        return StringUtils.isNotEmpty((CharSequence)this.sidx);
    }

    protected void initFilter() throws JSONException {
        TopiaPagerBeanBuilder builder = new TopiaPagerBeanBuilder(this.pager);
        if (this.useSort()) {
            builder.setSortAscendant(this.isSortAscendant().booleanValue()).setSortcolumn(this.getSortColumn());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.filters)) {
            Map filterObject = (Map)JSONUtil.deserialize((String)this.filters);
            String groupOp = (String)filterObject.get("groupOp");
            Collection rules = (Collection)filterObject.get("rules");
            if (CollectionUtils.isNotEmpty((Collection)rules)) {
                for (Map rule : rules) {
                    if (!"ID".equals(rule.get("field"))) continue;
                    rule.put("field", "id");
                }
            }
            this.pager = builder.setFilterOperationGroup(groupOp).addRules(rules).toBean();
        } else if (StringUtils.isNotEmpty((CharSequence)this.searchField)) {
            this.pager = builder.setFilterOperationGroup("AND").addRule(this.searchOper, this.searchField, this.searchString).toBean();
        }
    }
}

