package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.inject.Inject;

/**
 * To configure and show spatial datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class Show extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(Show.class);

    @Inject
    protected transient SpatialService spatialService;

    protected final ShowSpatialModel model = new ShowSpatialModel();

    public ShowSpatialModel getModel() {
        return model;
    }

    protected boolean canAddSpatial;

    protected String lizmapRepository;

    public String getLizmapUrl() {
        String url = getServiceContext().getConfiguration().getLizmapUrl() + "?" +
                "repository=" + lizmapRepository;
        return url;
    }

    public String getLizmapRepository() {
        return lizmapRepository;
    }

    public boolean isCanAddSpatial() {
        return canAddSpatial;
    }

    @Override
    public String execute() throws Exception {

        JdbcConfiguration dbConf = getEchoBaseSession().getWorkingDbConfiguration();

        lizmapRepository = spatialService.generateMaps(dbConf);

        if (log.isInfoEnabled()) {
            log.info("Loading spatial view for repository: " + lizmapRepository);
        }

        model.setJdbcUrl(getServiceContext().getUserDbUrl());
        model.setWithSpatial(spatialService.isSpatialAware());

        // can add postgis if working db is postgresql and has still no echobase
        // spatial db
        canAddSpatial = !model.isWithSpatial() && spatialService.isPostgresql();
        return SUCCESS;
    }

}
