/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportCoser;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.CoserApiService;
import fr.ifremer.echobase.services.service.exportCoser.ExportCoserConfiguration;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends AbstractConfigureAction<ExportCoserConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    @Inject
    private transient CoserApiService coserApiService;
    protected Map<String, String> missions;
    protected Map<String, String> populationIndicators;
    protected Map<String, String> communityIndicators;
    protected Map<String, String> facades;
    protected Map<String, String> zones;

    public Configure() {
        super(ExportCoserConfiguration.class);
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getFacades() {
        return this.facades;
    }

    public Map<String, String> getZones() {
        return this.zones;
    }

    public Map<String, String> getPopulationIndicators() {
        return this.populationIndicators;
    }

    public Map<String, String> getCommunityIndicators() {
        return this.communityIndicators;
    }

    protected ExportCoserConfiguration createModel() {
        ExportCoserConfiguration result = new ExportCoserConfiguration();
        EchoBaseSession userSession = this.getEchoBaseSession();
        JdbcConfiguration workingDbConfiguration = userSession.getWorkingDbConfiguration();
        result.setDbConfiguration(workingDbConfiguration);
        result.setUserName(userSession.getUser().getEmail());
        return result;
    }

    protected void prepareInputAction(ExportCoserConfiguration model) {
        this.loadInputs();
    }

    protected void prepareExecuteAction(ExportCoserConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-exportCoser-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        this.loadInputs();
    }

    protected void loadInputs() {
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
        this.facades = this.coserApiService.getFacades();
        this.zones = StringUtils.isNotEmpty((CharSequence)((ExportCoserConfiguration)this.getModel()).getFacade()) ? this.coserApiService.getZonesForFacade(((ExportCoserConfiguration)this.getModel()).getFacade()) : Maps.newHashMap();
        Set indicatorNames = this.coserApiService.getIndicators();
        List dataMetadatas = this.userDbPersistenceService.getDataMetadatasInName(indicatorNames);
        this.populationIndicators = this.decoratorService.sortAndDecorate((Collection)dataMetadatas, null);
        this.communityIndicators = this.decoratorService.sortAndDecorate((Collection)dataMetadatas, null);
    }
}

