/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.services.service.InternalDbPersistenceService;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryNotFoundException;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditExportQuery
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EditExportQuery.class);
    protected ExportQuery query;
    protected boolean canUpdateQuery;
    protected Map<String, String> queries;
    protected transient ExportQueryService exportQueryService;
    protected transient InternalDbPersistenceService internalDbPersistenceService;

    public ExportQuery getQuery() {
        if (this.query == null) {
            this.query = this.exportQueryService.newExportQuery();
        }
        return this.query;
    }

    public boolean isNewQuery() {
        return false;
    }

    public boolean isQueryExists() {
        return StringUtils.isNotEmpty((CharSequence)this.getQuery().getTopiaId());
    }

    public boolean isCanUpdateQuery() {
        return this.canUpdateQuery;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public String execute() throws ExportQueryNotFoundException {
        this.queries = this.internalDbPersistenceService.loadSortAndDecorate(ExportQuery.class);
        String selectedQueryId = this.getQuery().getTopiaId();
        this.query = this.exportQueryService.getExportQuery(selectedQueryId);
        EchoBaseUser echoBaseUser = this.getEchoBaseSession().getUser();
        boolean bl = this.canUpdateQuery = echoBaseUser.isAdmin() || echoBaseUser.getEmail().equals(this.query.getLastModifiedUser());
        if (!this.canUpdateQuery) {
            this.addFlashMessage(this._("echobase.info.sqlQuery.not.modifiable", new Object[0]));
        }
        this.checkQuery();
        return "success";
    }

    private boolean checkQuery() {
        boolean result;
        try {
            this.exportQueryService.testSql(this.getQuery().getSqlQuery());
            result = true;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (log.isWarnEnabled()) {
                log.warn((Object)"Invalid sql ", cause);
            }
            this.addFieldError("query.sqlQuery", this._("echobase.error.invalid.sql", new Object[]{cause.getMessage()}));
            result = false;
        }
        return result;
    }

    public void setExportQueryService(ExportQueryService exportQueryService) {
        this.exportQueryService = exportQueryService;
    }

    public void setInternalDbPersistenceService(InternalDbPersistenceService internalDbPersistenceService) {
        this.internalDbPersistenceService = internalDbPersistenceService;
    }
}

