package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Information.java 881 2013-11-03 10:39:54Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/Information.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * Display a page to show connection details.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class Information extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected JdbcConfiguration dbConfiguration;

    protected String pilotVersion;

    protected boolean canAddSpatial;

    protected boolean spatialAware;

    public JdbcConfiguration getDbConfiguration() {
        return dbConfiguration;
    }

    public String getPilotVersion() {
        return pilotVersion;
    }

    public boolean isCanAddSpatial() {
        return canAddSpatial;
    }

    public boolean isSpatialAware() {
        return spatialAware;
    }

    @Override
    public String execute() throws Exception {

        EchoBaseConfiguration configuration =
                getEchoBaseApplicationContext().getConfiguration();

        dbConfiguration = getEchoBaseSession().getWorkingDbConfiguration();

        dbConfiguration = JdbcConfiguration.newConfig(
                dbConfiguration.getDriverType(),
                dbConfiguration.getUrl().replaceAll("\\\\", "/"),
                dbConfiguration.getLogin(),
                dbConfiguration.getPassword());

        pilotVersion =
                dbConfiguration.getDriverType().getPilotVersion(configuration);

        spatialAware = spatialService.isSpatialAware();

        // can add postgis if working db is postgresql and has still no echobase
        // spatial db
        canAddSpatial = !spatialAware && spatialService.isPostgresql();
        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient SpatialService spatialService;

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}
