<%--
  #%L
  EchoBase :: UI
  %%
  Copyright (C) 2011 - 2013 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  <s:text name="echobase.title.show.spatial"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:if test="model.withSpatial">

  <script type="text/javascript">

    jQuery(document).ready(function () {

      var voyageComboBox = $('[name="model.voyageId"]');

      var loadvoyageData = function(voyageId) {

        var spatialView = $('#spatialViewContainer');
        var spatialViewContent = $('#spatialViewContent');
        if (voyageId!='') {

          // load spatial view
          spatialViewContent.html('<s:text name="echobase.spatialView.loading"/>');
          spatialView.show();
          console.info('Load spatial view '+voyageId);


          jQuery.get(
            '<s:url action="showMap" namespace="/spatial"/>',
            {
              "model.voyageId": voyageComboBox.val()
            },
            function (result) {

              // inject result
              spatialViewContent.html(result);
            });
        } else {

          // hide spatial view
          spatialView.hide();
          spatialViewContent.html("");
        }
      };

      voyageComboBox.change(function () {
        loadvoyageData(this.value);
      });

      loadvoyageData('<s:property value="model.voyageId"/>');

    });
  </script>

  <s:form namespace="/spatial" method="POST" enctype="multipart/form-data">

    <div class="toolbar">
      <ul class="toolbar floatRight">
        <li>
          <s:submit action='refreshSpatialViews' key="echobase.action.reloadSpatialData"/>
        </li>
      </ul>
    </div>

    <fieldset>
      <legend>
        <s:text name="echobase.legend.showData.configure"/>
      </legend>

      <div class="cleanBoth help">
        <s:a href="%{getDocumentation('showSpatialData.html', null)}" target="doc">
          <s:text name="echobase.action.show.showSpatialData.documentation"/>
        </s:a>
      </div>
      <br/>

      <s:select key="model.voyageId" requiredLabel="true"
                label='%{getText("echobase.common.voyage")}'
                list="voyages" headerKey="" headerValue=""/>

      <s:hidden key="model.withSpatial" label=' '/>

    </fieldset>


    <div id="spatialViewContainer">
      <fieldset>
        <legend>
          <s:text name="echobase.legend.showData.result"/>
        </legend>

        <div id="spatialViewContent"></div>
      </fieldset>
    </div>

  </s:form>
</s:if>
<s:else>

  <p>
    <s:text name="echobase.message.no.spatial.database.support"/>
  </p>

  <s:if test="canAddSpatial">
    <br/>
    <s:form id="createForm" namespace="/spatial">
      <ul class="toolbar floatLeft">

        <li>
          <s:submit theme="simple" action="addSpatial"
                    key="echobase.action.workingDbconfiguration.addSpatial"/>
        </li>

      </ul>
    </s:form>
  </s:if>
</s:else>


