/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportMap;

import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.exportMap.ExportMapConfiguration;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends AbstractConfigureAction<ExportMapConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected Map<String, String> missions;

    public Configure() {
        super(ExportMapConfiguration.class);
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public String getFacadeName() {
        return ((ExportMapConfiguration)this.getModel()).getFacadeName();
    }

    public void setFacadeName(String facadeName) {
        ((ExportMapConfiguration)this.getModel()).setFacadeName(facadeName);
    }

    public String getZoneName() {
        return ((ExportMapConfiguration)this.getModel()).getZoneName();
    }

    public void setZoneName(String zoneName) {
        ((ExportMapConfiguration)this.getModel()).setZoneName(zoneName);
    }

    public String getMissionId() {
        return ((ExportMapConfiguration)this.getModel()).getMissionId();
    }

    protected ExportMapConfiguration createModel() {
        ExportMapConfiguration result = new ExportMapConfiguration();
        result.setFacadeName("atlantique");
        result.setZoneName("gdgciem8");
        EchoBaseSession userSession = this.getEchoBaseSession();
        JdbcConfiguration workingDbConfiguration = userSession.getWorkingDbConfiguration();
        result.setDbConfiguration(workingDbConfiguration);
        result.setUserName(userSession.getUser().getEmail());
        return result;
    }

    protected void prepareInputAction(ExportMapConfiguration model) {
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
    }

    protected void prepareExecuteAction(ExportMapConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-exportMap-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
    }
}

