package fr.ifremer.echobase.ui.actions.exportMap;

/*
 * #%L
 * EchoBase :: UI
 * %%
 * Copyright (C) 2011 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.exportMap.ExportMapConfiguration;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * Created on 3/1/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class Configure extends AbstractConfigureAction<ExportMapConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Configure.class);

    /** Universe of voyages to export in db. */
    protected Map<String, String> missions;

    public Configure() {
        super(ExportMapConfiguration.class);
    }

    public Map<String, String> getMissions() {
        return missions;
    }


    public String getFacadeName() {
        return getModel().getFacadeName();
    }

    public void setFacadeName(String facadeName) {
        getModel().setFacadeName(facadeName);
    }

    public String getZoneName() {
        return getModel().getZoneName();
    }

    public void setZoneName(String zoneName) {
        getModel().setZoneName(zoneName);
    }

    public String getMissionId() {
        return getModel().getMissionId();
    }

    @Override
    protected ExportMapConfiguration createModel() {
        ExportMapConfiguration result = new ExportMapConfiguration();
        result.setFacadeName("atlantique");
        result.setZoneName("gdgciem8");

        EchoBaseSession userSession = getEchoBaseSession();
        JdbcConfiguration workingDbConfiguration = userSession.getWorkingDbConfiguration();
        result.setDbConfiguration(workingDbConfiguration);
        result.setUserName(userSession.getUser().getEmail());
        return result;
    }

    @Override
    protected void prepareInputAction(ExportMapConfiguration model) {

        missions = userDbPersistenceService.loadSortAndDecorate(Mission.class);
    }

    @Override
    protected void prepareExecuteAction(ExportMapConfiguration model) throws IOException {

        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory,
                                      "echobase-exportMap-" +
                                      System.currentTimeMillis()
        );
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }

        missions = userDbPersistenceService.loadSortAndDecorate(Mission.class);
    }
}
