/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.DataMetadata;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class GetVoyageDataMetadata
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String voyageId;
    protected Map<String, String> data;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;
    @Inject
    protected transient SpatialService spatialService;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String execute() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.voyageId)) {
            this.data = Maps.newLinkedHashMap();
        } else {
            Voyage voyage = this.userDbPersistenceService.getVoyage(this.voyageId);
            Preconditions.checkNotNull((Object)voyage, (Object)("Could not find voyage with id " + this.voyageId));
            this.data = this.userDbPersistenceService.loadSortAndDecorate(DataMetadata.class);
        }
        return "success";
    }
}

