/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.services.service.InternalDbPersistenceService;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryNotFoundException;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateNewExportQuery
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CreateNewExportQuery.class);
    protected ExportQuery query;
    protected Map<String, String> queries;
    protected transient ExportQueryService exportQueryService;
    protected transient InternalDbPersistenceService internalDbPersistenceService;

    public ExportQuery getQuery() {
        if (this.query == null) {
            this.query = this.exportQueryService.newExportQuery();
        }
        return this.query;
    }

    public boolean isNewQuery() {
        return true;
    }

    public boolean isQueryExists() {
        return false;
    }

    public boolean isCanUpdateQuery() {
        return false;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public String execute() throws ExportQueryNotFoundException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will create a new query");
        }
        this.queries = this.internalDbPersistenceService.loadSortAndDecorate(ExportQuery.class);
        this.addFlashMessage(this._("echobase.info.new.sqlQuery.inprogress", new Object[0]));
        return "success";
    }

    public void setExportQueryService(ExportQueryService exportQueryService) {
        this.exportQueryService = exportQueryService;
    }

    public void setInternalDbPersistenceService(InternalDbPersistenceService internalDbPersistenceService) {
        this.internalDbPersistenceService = internalDbPersistenceService;
    }
}

