package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GeoJsonObject.java 843 2013-08-20 06:07:41Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/GeoJsonObject.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class GeoJsonObject implements Serializable {

    private static final long serialVersionUID = 1L;


    public static GeoJsonObjectBuilder newBuilder(String type) {
        return new GeoJsonObjectBuilder(type);
    }

    public static class GeoJsonObjectBuilder {

        GeoJsonObject result = new GeoJsonObject();

        GeoJsonFeature feature;

        public GeoJsonObjectBuilder(String type) {
            result.type = type;
        }

        public GeoJsonObjectBuilder newFeature(String type,
                                               String id,
                                               String geometryType) {
            feature = new GeoJsonFeature(type, id);
            result.features.add(feature);
            feature.geometry = new GeoJsonGeometry(geometryType);
            return this;
        }

        public GeoJsonObjectBuilder addFeatureProperty(String key, Serializable value) {
            Preconditions.checkNotNull(feature, "No feature (use before newFeature method)");
            feature.getProperties().put(key, value);
            return this;
        }

        public GeoJsonObjectBuilder addFeatureGeometryPoint(double latitude, double longitude) {
            Preconditions.checkNotNull(feature, "No feature (use before newFeature method)");
            feature.geometry.coordinates = new double[]{latitude, longitude};
            return this;
        }

        public GeoJsonObject flush() {
            return result;
        }
    }

    protected String type;

    protected final List<GeoJsonFeature> features = Lists.newArrayList();

    public String getType() {
        return type;
    }

    public List<GeoJsonFeature> getFeatures() {
        return features;
    }

    public static class GeoJsonFeature implements Serializable {

        private static final long serialVersionUID = 1L;

        protected String type;

        protected String id;

        protected final Map<String, Serializable> properties =
                Maps.newLinkedHashMap();

        protected GeoJsonGeometry geometry;

        public GeoJsonFeature(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return type;
        }

        public String getId() {
            return id;
        }

        public Map<String, Serializable> getProperties() {
            return properties;
        }

        public GeoJsonGeometry getGeometry() {
            return geometry;
        }
    }

    public static class GeoJsonGeometry implements Serializable {

        private static final long serialVersionUID = 1L;

        protected String type;

        protected double[] coordinates;

        public GeoJsonGeometry(String type) {
            this.type = type;
        }

        public String getType() {
            return type;
        }

        public double[] getCoordinates() {
            return coordinates;
        }
    }

}
