/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetEntities.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fr.ifremer.echobase.EchoBaseFunctions;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.topia.persistence.pager.FilterRule;
import org.nuiton.topia.persistence.pager.FilterRuleGroupOperator;
import org.nuiton.topia.persistence.pager.FilterRuleOperator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

/**
 * To obtain the data for the given request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetEntities extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(GetEntities.class);

    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public String execute() throws Exception {

        Boolean ascendantOrder = isSortAscendant();
        String sortColumn = getSortColumn();

        initFilter();

        if (log.isDebugEnabled()) {
            log.debug("filters      = " + getFilters());
            log.debug("sidx         = " + sortColumn);
            log.debug("sord         = " + ascendantOrder);
        }

        datas = dbEditorService.getData(entityType, pager);

        if (log.isDebugEnabled()) {
            log.debug("Total page = " + getTotal());
        }

        return SUCCESS;
    }


    public String entityModificationLogs() throws Exception {
        entityType = EchoBaseEntityEnum.EntityModificationLog;
        execute();
        return SUCCESS;
    }

    public String entityImportLogs() throws Exception {
        entityType = EchoBaseEntityEnum.ImportLog;

        if (StringUtils.isNotBlank(voyageId)) {

            // add a filter on voyageId
            pager.setRules(Arrays.asList(new FilterRule(
                    FilterRuleOperator.eq, ImportLog.PROPERTY_VOYAGE_ID, voyageId
            )));
            pager.setGroupOp(FilterRuleGroupOperator.AND);
        }
        execute();
        Map<String, String> importTypes =
                decoratorService.decorateEnums(ImportType.values());

        for (Map row : datas) {

            String importType = (String) row.get(ImportLog.PROPERTY_IMPORT_TYPE);
            String importTypeToString = importTypes.get(importType);
            row.put(ImportLog.PROPERTY_IMPORT_TYPE, importTypeToString);

            dbEditorService.decorateForeignKey(row, Voyage.class, ImportLog.PROPERTY_VOYAGE_ID, null);
        }
        return SUCCESS;
    }

    public String dashboardImportLogs() throws Exception {
        entityType = EchoBaseEntityEnum.Voyage;
        execute();


        Decorator<ImportLog> importLogDecorator = decoratorService.getDecorator(
                getLocale(), ImportLog.class, DecoratorService.DATE_ONLY);

        Multimap<String, ImportLog> importLogsByVoyage = Multimaps.index(
                workingDbPersistenceService.getImportLogDAO().findAll(),
                EchoBaseFunctions.IMPORT_LOG_VOYAGE_ID);

        for (Map row : datas) {

            String id = (String) row.get("id");

            Collection<ImportLog> importLogs = importLogsByVoyage.get(id);

            dbEditorService.decorateForeignKey(row, Voyage.class, "id", null);

            // to keep importLogs decorated, indexed by their topiaId
            Map<String, String> imports = Maps.newHashMap();

            // to keep importLogs ids indexed by their importType
            Multimap<ImportType, String> result = ArrayListMultimap.create();

            for (ImportLog importLog : importLogs) {
                String importLogToString =
                        importLogDecorator.toString(importLog);
                String importId = importLog.getTopiaId();
                imports.put(importId, importLogToString);
                result.put(importLog.getImportType(), importId);
            }
            row.put("importLogs", imports);

            for (ImportType importType : result.keySet()) {
                row.put("importType." + importType.name(), result.get(importType));
            }


        }
        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient WorkingDbPersistenceService workingDbPersistenceService;

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }

    protected transient DbEditorService dbEditorService;

    public void setDbEditorService(DbEditorService dbEditorService) {
        this.dbEditorService = dbEditorService;
    }

    protected transient DecoratorService decoratorService;

    public void setDecoratorService(DecoratorService decoratorService) {
        this.decoratorService = decoratorService;
    }
}
