package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: AbstractGetVoyage.java 844 2013-09-11 15:58:38Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/AbstractGetVoyage.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * Abstract action to obtain some data linked with a given voyage id.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public abstract class AbstractGetVoyage extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Selected voyage id. */
    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    /** Universe of result. */
    protected Map<String, String> data;

    protected abstract Map<String, String> buildData(SpatialService service,
                                                     Voyage voyage);

    public abstract Map<String, String> getData();

    @Override
    public String execute() throws Exception {

        if (StringUtils.isEmpty(voyageId)) {
            data = Maps.newLinkedHashMap();

        } else {

            Voyage voyage = workingDbPersistenceService.getVoyageDAO().findByTopiaId(voyageId);

            Preconditions.checkNotNull(
                    voyage,
                    "Could not find voyage with id " + voyageId);

            data = buildData(spatialService, voyage);
        }

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient WorkingDbPersistenceService workingDbPersistenceService;

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }

    protected transient SpatialService spatialService;

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}