/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.services.service.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.services.service.importdata.AbstractImportDataService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractLaunchImport<M extends AbstractImportConfiguration, S extends AbstractImportDataService<M>>
extends AbstractWaitAndExecAction<M, S> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);
    @Inject
    protected transient EchoBaseUserPersistenceContext persistenceContext;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        super(modelType, serviceType);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.importData.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.importData.failed", new Object[0]);
    }

    protected String getResultMessage(M model) {
        String message = this.t("echobase.message.importData.result", new Object[]{model.getActionTime(), model.getResultMessage()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + message));
        }
        return message;
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.importData.result.resume", new Object[0]);
    }

    protected void startAction(S service, M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports for " + this.getModel()));
        }
        model.setResultMessage(service.doImport(model, this.getEchoBaseSession().getUser()));
    }

    protected void closeAction(M model) throws Exception {
        this.destroyModel(model);
    }
}

