package fr.ifremer.echobase.ui.actions.user;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Logout.java 591 2012-09-02 16:38:43Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/user/Logout.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * Log out from EchoBase.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class Logout extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    @Override
    public String execute() throws Exception {

        EchoBaseSession userSession = getEchoBaseSession();

        // remove echoBaseSession from application session
        getEchoBaseApplicationContext().destroyEchoBaseSession(userSession);

        // clean it from ActionContext (we never know...)
        EchoBaseSession.removeEchoBaseSession(getActionContext());

        return SUCCESS;
    }
}
