package fr.ifremer.echobase.ui.actions.removeData;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Delete.java 675 2012-09-20 16:03:59Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/removeData/Delete.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.services.removedata.RemoveDataConfiguration;
import fr.ifremer.echobase.services.removedata.RemoveDataService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Delete a selected import Log.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class Delete extends AbstractWaitAndExecAction<RemoveDataConfiguration, RemoveDataService> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Delete.class);

    public Delete() {
        super(RemoveDataConfiguration.class, RemoveDataService.class);
    }

    @Override
    protected String getSuccesMessage() {
        return _("echobase.info.removeData.succeded");
    }

    @Override
    protected String getErrorMessage() {
        return _("echobase.info.removeData.failed");
    }

    @Override
    protected String getResultMessage(RemoveDataConfiguration model) {
        String message = _("echobase.message.removeData.result",
                           model.getActionTime(), model.getResultMessage());
        if (log.isInfoEnabled()) {
            log.info("Result: " + message);
        }
        return message;
    }

    @Override
    public String getActionResumeTitle() {
        return _("echobase.legend.removeData.resume");
    }

    @Override
    protected void startAction(RemoveDataService service,
                               RemoveDataConfiguration model) throws Exception {

        String resultMessage = service.removeImport(
                model, getEchoBaseSession().getUser());
        model.setResultMessage(resultMessage);
    }

    @Override
    protected void closeAction(RemoveDataConfiguration model) throws Exception {
        destroyModel(model);
    }
}
