/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.services.AbstractEchobaseActionConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConfigureAction<M extends AbstractEchobaseActionConfiguration>
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractConfigureAction.class);
    private final Class<M> modelType;
    private M model;

    protected abstract M createModel();

    protected abstract void prepareExecuteAction(M var1) throws IOException;

    protected AbstractConfigureAction(Class<M> modelType) {
        this.modelType = modelType;
    }

    public final String input() throws Exception {
        this.getEchoBaseSession().removeActionConfiguration(this.modelType);
        this.prepareInputAction(this.getModel());
        return "input";
    }

    @InputConfig(methodName="input")
    public final String execute() throws Exception {
        this.prepareExecuteAction(this.getModel());
        this.setInSession(this.getModel());
        return "success";
    }

    public final M getModel() {
        if (this.model == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will create model " + this.modelType.getName()));
            }
            this.model = this.createModel();
        }
        return (M)this.model;
    }

    protected void prepareInputAction(M model) {
    }

    protected final void setInSession(M model) {
        this.getEchoBaseSession().setActionConfiguration(model);
    }

    protected final M getFromSession() {
        return (M)this.getEchoBaseSession().getActionConfiguration(this.modelType);
    }
}

