package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Create.java 591 2012-09-02 16:38:43Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/Create.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.WorkingDbConfiguration;
import org.apache.commons.lang3.StringUtils;

/**
 * To create a new {@link WorkingDbConfiguration}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class Create extends AbstractWorkingDbAction {

    private static final long serialVersionUID = 1L;

    public boolean isNewConf() {
        return true;
    }

    public String createConf() throws Exception {

        // new workingDbConfiguration in progress
        addFlashMessage(
                _("echobase.info.new.workingDbConfiguration.inprogress"));

        return INPUT;
    }

    public String cloneConf() throws Exception {

        getConf().setTopiaId(null);

        // new workingDbConfiguration in progress
        addFlashMessage(
                _("echobase.info.new.workingDbConfiguration.inprogress"));

        return INPUT;
    }

    @InputConfig(methodName = INPUT)
    @Override
    public String execute() throws Exception {

        conf = getService().create(getConf());

        addFlashMessage(_("echobase.info.workingDbconfiguration.created",
                           conf.getUrl()));

        return SUCCESS;
    }

    @Override
    public void validate() {

        if (StringUtils.isBlank(getConf().getUrl())) {
            addFieldError(
                    "conf.url",
                    _("echobase.error.workingDbConfiguration.url.required"));
        } else {

            if (!isConfExists()) {

                // when creating a request
                // check this url does not exists

                boolean urlUsed = getService().isUrlAlreadyUsed(getConf().getUrl());
                if (urlUsed) {
                    addFieldError("conf.url",
                                  _("echobase.error.workingDbConfiguration.url.already.exists"));
                }
            }
        }

        if (StringUtils.isBlank(getConf().getLogin())) {
            addFieldError(
                    "conf.login",
                    _("echobase.error.workingDbConfiguration.login.required"));
        }

        if (StringUtils.isBlank(getConf().getDescription())) {
            addFieldError(
                    "conf.description",
                    _("echobase.error.workingDbConfiguration.description.required"));
        }
    }
}
