/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.Vessel;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.decorator.Decorator;

public class GetVesselsForVoyage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String voyageId;
    protected Map<String, String> vessels;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public String execute() throws Exception {
        this.vessels = Maps.newLinkedHashMap();
        if (StringUtils.isNotEmpty((CharSequence)this.voyageId)) {
            EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.getService(EchoBaseServiceSupport.class);
            Voyage voyage = (Voyage)service.getEntityById(Voyage.class, this.voyageId);
            Preconditions.checkNotNull((Object)voyage, (Object)("Could not find voyage with id " + this.voyageId));
            if (!voyage.isTransitEmpty()) {
                DecoratorService decoratorService = (DecoratorService)service.getService(DecoratorService.class);
                Decorator decorator = decoratorService.getDecorator(this.getLocale(), Vessel.class, null);
                Set allVessels = voyage.getAllVessels();
                for (Vessel vessel : allVessels) {
                    String value = decorator.toString((Object)vessel);
                    this.vessels.put(vessel.getTopiaId(), value);
                }
            }
        }
        return "success";
    }
}

