package fr.ifremer.echobase.ui;

/*
 * #%L
 * EchoBase :: UI
 * $Id: EchoBaseWorkingDbTransactionFilter.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/EchoBaseWorkingDbTransactionFilter.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsStatics;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * To inject a transaction coming from the user connected working db.
 * <p/>
 * If user has no working db selected, then do nothing.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class EchoBaseWorkingDbTransactionFilter extends TopiaTransactionFilter {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EchoBaseWorkingDbTransactionFilter.class);

    public static final String USER_TRANSACTION = "userTransaction";

    public static TopiaContext getTransaction(ActionContext context) {
        HttpServletRequest request = (HttpServletRequest)
                context.get(StrutsStatics.HTTP_REQUEST);
        return (TopiaContext) request.getAttribute(USER_TRANSACTION);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        setRequestAttributeName(USER_TRANSACTION);
    }

    @Override
    public TopiaContext beginTransaction(ServletRequest request) {

        HttpSession session = ((HttpServletRequest) request).getSession();
        Preconditions.checkNotNull(session);
        EchoBaseSession userSession = EchoBaseSession.getEchoBaseSession(session);
        Preconditions.checkNotNull(userSession);
        TopiaContext rootContext = userSession.getWorkingDbRootContext();
        Preconditions.checkNotNull(rootContext);
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug("Starts a new working db transaction " + transaction);
            }
            return transaction;
        } catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", eee);
        }
    }

}