/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetEntity.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetEntity.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.topia.persistence.metadata.ColumnMeta;
import org.nuiton.topia.persistence.metadata.TableMeta;

import java.util.List;
import java.util.Map;

/**
 * To obtain the data for the given entity.
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class GetEntity extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    /** Id of entity to load. */
    protected String id;

    /** Datas of the given table. */
    protected Map<?, ?> datas;

    /** Universe of columns metat datas of the selected entity type. */
    protected Map<String, ColumnMeta> metas;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<?, ?> getDatas() {
        return datas;
    }

    public Map<String, ColumnMeta> getMetas() {
        return metas;
    }

    @Override
    public String execute() throws Exception {

        TableMeta<EchoBaseEntityEnum> table =
                getServiceContext().getDbMeta().getTable(entityType);

        datas = getService(DbEditorService.class).getData(table, id);

        Object length = datas.remove("length");
        if (length != null) {

            // replace it by length_ (ovtherwise javascript won't work)
            ((Map) datas).put("length_", length);
        }
        List<ColumnMeta> columnMetas = table.getColumns();
        metas = Maps.newHashMap();
        for (ColumnMeta columnMeta : columnMetas) {
            metas.put(columnMeta.getName(), columnMeta);
        }
        return SUCCESS;
    }
}
