/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.services.importdata.AbstractImportDataService;
import fr.ifremer.echobase.services.importdata.ImportException;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractLaunchImport<M extends AbstractImportConfiguration, S extends AbstractImportDataService<M>>
extends AbstractWaitAndExecAction<M, S> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);
    protected transient Exception error;
    protected String result;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        super(modelType, serviceType);
    }

    public String getResult() {
        return this.result;
    }

    public Exception getError() {
        return this.error;
    }

    public String getErrorStack() {
        String errorStack = null;
        if (this.error != null) {
            errorStack = ExceptionUtils.getStackTrace((Throwable)this.error);
        }
        return errorStack;
    }

    protected void startAction(S service, M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports for " + this.getModel()));
        }
        try {
            this.result = service.doImport(model, this.getEchoBaseSession().getUser());
            this.addFlashMessage(this._("echobase.info.import.succeded", new Object[0]));
        }
        catch (ImportException e) {
            this.addFlashError(this._("echobase.info.import.failed", new Object[0]));
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while import ", (Throwable)e);
            }
            this.error = e;
        }
    }
}

