/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.exportdb.ExportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.dbeditor.ImportTable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class ExportTable
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportTable.class);
    protected EchoBaseEntityEnum entityType;
    protected String exportFileName;
    protected transient InputStream inputStream;
    protected long contentLength;
    protected String contentType;
    protected boolean exportAsSeen;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public void setExportAsSeen(boolean exportAsSeen) {
        this.exportAsSeen = exportAsSeen;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public String execute() throws Exception {
        TableMeta table = this.getServiceContext().getDbMeta().getTable((TopiaEntityEnum)this.entityType);
        String content = ((ExportService)this.getService(ExportService.class)).exportData(table, this.exportAsSeen);
        if (log.isDebugEnabled()) {
            log.debug((Object)("file to export " + content));
        }
        this.contentLength = content.length() * 2;
        this.contentType = "text/csv";
        this.inputStream = new ByteArrayInputStream(content.getBytes());
        return "success";
    }
}

