/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.services.AbstractEchobaseActionConfiguration;
import fr.ifremer.echobase.services.EchoBaseService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.IOException;
import org.nuiton.topia.TopiaContext;

public abstract class AbstractWaitAndExecAction<M extends AbstractEchobaseActionConfiguration, S extends EchoBaseService>
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private final Class<M> modelType;
    private final Class<S> serviceType;
    private M model;
    private ActionContext actionContext;

    protected AbstractWaitAndExecAction(Class<M> modelType, Class<S> serviceType) {
        this.modelType = modelType;
        this.serviceType = serviceType;
    }

    protected abstract void startAction(S var1, M var2) throws Exception;

    public final M getModel() {
        return (M)this.model;
    }

    public void prepare() throws Exception {
        if (this.actionContext == null) {
            this.actionContext = ActionContext.getContext();
        } else {
            ActionContext.setContext((ActionContext)this.actionContext);
        }
        this.model = this.getEchoBaseSession().getActionConfiguration(this.modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String execute() throws Exception {
        this.model.beginAction();
        ActionContext.setContext((ActionContext)this.actionContext);
        TopiaContext tx = EchoBaseEntityHelper.newTransactionFromRootContext((TopiaContext)this.getServiceContext().getTransaction());
        try {
            this.getServiceContext().setTransaction(tx);
            EchoBaseService service = this.getService(this.serviceType);
            this.startAction(service, this.model);
            this.model.endAction();
            String string = "success";
            return string;
        }
        finally {
            try {
                EchoBaseEntityHelper.closeConnection((TopiaContext)tx);
            }
            finally {
                this.closeAction(this.model);
            }
        }
    }

    protected void closeAction(M model) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyModel(M model) throws IOException {
        try {
            model.destroy();
        }
        finally {
            this.getEchoBaseSession().removeActionConfiguration(this.modelType);
        }
    }
}

