/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.EchobaseTopiaContexts;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.AbstractEchobaseActionConfiguration;
import java.io.Closeable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;

public class EchoBaseSession
implements Closeable {
    private static final Log log = LogFactory.getLog(EchoBaseSession.class);
    private static final String SESSION_PARAMETER = "echoBaseSession";
    private static final String PROPERTY_USER = "echobaseUser";
    private static final String PROPERTY_WORKING_DB_CONFIGURATION = "workingDbConfiguration";
    private static final String PROPERTY_WORKING_DB_ROOT_CONTEXT = "workingDbRootContext";
    public static final String SESSION_TOKEN_MESSAGES = "messages";
    public static final String SESSION_TOKEN_ERRORS = "errors";
    public static final String SESSION_TOKEN_WARNINGS = "warnings";
    protected Map<String, Object> store = new TreeMap();

    public static EchoBaseSession getEchoBaseSession(ActionContext actionContext) {
        Map session = actionContext.getSession();
        EchoBaseSession userSession = (EchoBaseSession)session.get(SESSION_PARAMETER);
        if (userSession == null) {
            userSession = new EchoBaseSession();
            session.put(SESSION_PARAMETER, userSession);
        }
        return userSession;
    }

    public static EchoBaseSession getEchoBaseSession(HttpSession session) {
        EchoBaseSession userSession = (EchoBaseSession)session.getAttribute(SESSION_PARAMETER);
        if (userSession == null) {
            userSession = new EchoBaseSession();
            session.setAttribute(SESSION_PARAMETER, (Object)userSession);
        }
        return userSession;
    }

    public static void removeEchoBaseSession(ActionContext actionContext) {
        Map session = actionContext.getSession();
        session.remove(SESSION_PARAMETER);
    }

    public EchoBaseUser getUser() {
        return (EchoBaseUser)this.get(PROPERTY_USER, EchoBaseUser.class);
    }

    public boolean isAdmin() {
        EchoBaseUser user = this.getUser();
        return user != null && user.isAdmin();
    }

    public void setUser(EchoBaseUser user) {
        this.set(PROPERTY_USER, (Object)user);
    }

    public JdbcConfiguration getWorkingDbConfiguration() {
        return (JdbcConfiguration)this.get(PROPERTY_WORKING_DB_CONFIGURATION, JdbcConfiguration.class);
    }

    public TopiaContext getWorkingDbRootContext() {
        return (TopiaContext)this.get(PROPERTY_WORKING_DB_ROOT_CONTEXT, TopiaContext.class);
    }

    public boolean isWorkingDbSelected() {
        return this.contains(PROPERTY_WORKING_DB_CONFIGURATION);
    }

    public void initWorkingDb(JdbcConfiguration jdbcConfiguration) throws TopiaNotFoundException {
        this.releaseWorkingDb();
        TopiaContext rootContext = EchobaseTopiaContexts.newWorkingDb((JdbcConfiguration)jdbcConfiguration);
        this.set(PROPERTY_WORKING_DB_CONFIGURATION, (Object)jdbcConfiguration);
        this.set(PROPERTY_WORKING_DB_ROOT_CONTEXT, (Object)rootContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("User database initialized at " + jdbcConfiguration.getUrl()));
        }
    }

    public <C extends AbstractEchobaseActionConfiguration> C getActionConfiguration(Class<C> configurationType) {
        return (C)((AbstractEchobaseActionConfiguration)this.get(configurationType.getName(), configurationType));
    }

    public <C extends AbstractEchobaseActionConfiguration> void setActionConfiguration(C configurationType) {
        this.set(configurationType.getClass().getName(), configurationType);
    }

    public <C extends AbstractEchobaseActionConfiguration> void removeActionConfiguration(Class<C> configurationType) {
        this.remove(configurationType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWorkingDb() {
        if (this.isWorkingDbSelected()) {
            try {
                TopiaContext rootContext = this.getWorkingDbRootContext();
                EchoBaseEntityHelper.releaseRootContext((TopiaContext)rootContext);
            }
            finally {
                this.remove(PROPERTY_WORKING_DB_CONFIGURATION);
                this.remove(PROPERTY_WORKING_DB_ROOT_CONTEXT);
            }
        }
    }

    public <T extends Serializable> T getDynamicData(String token) {
        Object result = this.getDynamicData().get(token);
        return (T)((Serializable)result);
    }

    public <T extends Serializable> Set<T> getDynamicSetData(String token) {
        Object result = this.getDynamicData().get(token);
        return (Set)result;
    }

    public <T extends Serializable> T consumeDynamicData(String token) {
        Serializable result = this.getDynamicData(token);
        if (result != null) {
            this.removeDynamicData(token);
        }
        return (T)result;
    }

    public <T extends Serializable> Set<T> consumeDynamicSetData(String token) {
        Set result = this.getDynamicSetData(token);
        if (result != null) {
            this.removeDynamicData(token);
        }
        return result;
    }

    public <T extends Serializable> void putDynamicSetData(String token, Set<T> data) {
        this.getDynamicData().put(token, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void putDynamicData(String token, Serializable data) {
        this.getDynamicData().put(token, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void removeDynamicData(String token) {
        this.getDynamicData().remove(token);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void clearDynamicData() {
        if (this.store != null) {
            this.store.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dynamic attributes size : " + this.store.size()));
            }
        }
    }

    protected Map<String, Object> getDynamicData() {
        if (this.store == null) {
            this.store = Maps.newHashMap();
        }
        return this.store;
    }

    public void addMessage(String messageScope, String message) {
        Set messages = this.getDynamicSetData(messageScope);
        if (messages == null) {
            messages = Sets.newHashSet((Object[])new String[]{message});
            this.putDynamicSetData(messageScope, messages);
        } else {
            messages.add(message);
        }
    }

    protected EchoBaseSession() {
    }

    protected Object remove(String key) {
        Object remove = this.store.remove(key);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from user session data [" + key + "] = " + remove));
        }
        return remove;
    }

    protected boolean contains(String key) {
        boolean result = this.store.containsKey(key);
        return result;
    }

    protected <T> T get(String key, Class<T> type) {
        Object o = this.store.get(key);
        if (o != null && !type.isInstance(o)) {
            throw new ClassCastException("parameter " + key + " should be of type " + type.getName() + " but was " + o.getClass().getName());
        }
        return (T)o;
    }

    protected void set(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.store.put(key, value);
            if (log.isInfoEnabled()) {
                log.info((Object)("Set in user session data [" + key + "] = " + value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Close user session for [" + this.getUser().getEmail() + "]"));
        }
        try {
            this.releaseWorkingDb();
        }
        finally {
            HashSet keys = Sets.newHashSet(this.store.keySet());
            for (String key : keys) {
                this.remove(key);
            }
        }
    }
}

