/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractLaunchImport.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/AbstractLaunchImport.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.services.importdata.AbstractImportDataService;
import fr.ifremer.echobase.services.importdata.ImportException;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class AbstractLaunchImport<M extends AbstractImportConfiguration, S extends AbstractImportDataService<M>> extends AbstractWaitAndExecAction<M, S> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);

    protected transient Exception error;

    protected String result;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        super(modelType, serviceType);
    }

    public String getResult() {
        return result;
    }

    public Exception getError() {
        return error;
    }

    public String getErrorStack() {

        String errorStack = null;
        if (error != null) {

            errorStack = ExceptionUtils.getStackTrace(error);
        }

        return errorStack;
    }

    @Override
    protected void startAction(S service, M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Start imports for " + getModel());
        }

        try {
            result = service.doImport(model, getEchoBaseSession().getUser());

            addFlashMessage(_("echobase.info.import.succeded"));

        } catch (ImportException e) {

            addFlashError(_("echobase.info.import.failed"));

            if (log.isErrorEnabled()) {
                log.error("Error while import ", e);
            }

            error = e;
        }
    }

}
