<%--
  #%L
  EchoBase :: UI
  
  $Id: selectImportType.jsp 460 2012-03-30 16:46:14Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.6/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/selectImportType.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>

<title><s:text name="echobase.title.importData.selectImportType"/></title>

<script type="text/javascript">

  function updateMode(newValue) {
    // change the action target
    $('#selectImportType_configure').attr(
      'name',
      'action:configure' + newValue + '-input');
  }

  jQuery(document).ready(function () {

    $('[name="mode"]').change(function (event) {
      updateMode(this.value);
    });
    updateMode($('[name="mode"][checked="checked"]').val());
  });
</script>

<s:form namespace="/importData" method="GET">

  <s:submit action="createMission" key='echobase.action.createNewMission'
            method="input"/>
  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configuration.selectImportType"/>
    </legend>
    <s:radio key='mode' list="modes" cssClass="cleanBoth"
             label='%{getText("echobase.common.importDataMode")}'
             required="true" template="myradiomap"/>
  </fieldset>

  <s:submit action="selectImportType" key='echobase.action.configureImport'
            align="right"/>
</s:form>