<%--
  #%L
  EchoBase :: UI
  
  $Id: configureResultsImport.jsp 508 2012-04-06 20:36:22Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.6/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureResultsImport.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  Configuration <s:text name="echobase.common.importMode.results"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // to change form when mode is changed
    $('[name="model.importMode"]').change(function (event) {
      $('[class~="importMode"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    // show incoming mode
    var incomingVal = $('[name="model.importMode"][checked="checked"]').val();
    $('#' + incomingVal).show();

    $.autoSelectVoyageAndDataProcessing(
      $('#voyageSelectBox'),
      $('#dataProcessingSelectBox'),
      '<s:url action="getDataProcessingsForVoyage" namespace="/importData"/>',
      '<s:property value="model.voyageId"/>',
      '<s:property value="model.dataProcessingId"/>'
    );
  });
</script>

<s:radio id='mode' key='model.importMode' list="importModes"
         cssClass="cleanBoth"
         label='%{getText("echobase.common.importMode")}'
         required="true" template="myradiomap"/>

<s:form id="VOYAGE" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Rsultats_voyage"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importMode" value="VOYAGE" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:label key="echobase.information.one.file.required" required="true"
             value=''/>

    <s:file key="lengthAgeKeyFile"
            label='%{getText("echobase.common.lengthAgeKeyFile")}'/>

    <s:file key="lengthWeightKeyFile"
            label='%{getText("echobase.common.lengthWeightKeyFile")}'/>

    <s:file key="echotypeFile"
            label='%{getText("echobase.common.echotypeFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeVoyage" key='echobase.action.import'/>
</s:form>

<s:form id="ESDU" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Rsultats_Esdu"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importMode" value="ESDU" label=''/>

    <s:select id='voyageSelectBox' key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <sj:select id='dataProcessingSelectBox' key="model.dataProcessingId"
               required="true"
               label='%{getText("echobase.common.dataProcessing")}'/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:label key="echobase.information.one.file.required" required="true"
             value=''/>

    <s:file key="esduByEchotypeFile"
            label='%{getText("echobase.common.esduByEchotypeFile")}'/>

    <s:file key="esduByEchotypeAndSpeciesCategoryFile"
            label='%{getText("echobase.common.esduByEchotypeAndSpeciesCategoryFile")}'/>

    <s:file key="esduBySpeciesAndSizeCategoryFile"
            label='%{getText("echobase.common.esduBySpeciesAndSizeCategoryFile")}'/>

    <s:file key="esduBySpeciesAndAgeCategoryFile"
            label='%{getText("echobase.common.esduBySpeciesAndAgeCategoryFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeEsdu" key='echobase.action.import'/>
</s:form>

<s:form id="REGION" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Region"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importMode" value="REGION" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="regionsFile" required="true"
            label='%{getText("echobase.common.cellRegionsFile")}'/>

    <s:file key="regionAssociationFile" required="true"
            label='%{getText("echobase.common.cellRegionAssociationFile")}'/>

    <s:file key="regionResultFile" required="true"
            label='%{getText("echobase.common.cellRegionResultFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeRegion" key='echobase.action.import'/>
</s:form>

<s:form id="MAP" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Map"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importMode" value="MAP" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="mapsFile" required="true"
            label='%{getText("echobase.common.cellMapsFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeMap" key='echobase.action.import'/>
</s:form>
