/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importDb;

import fr.ifremer.echobase.services.ImportDbConfiguration;
import fr.ifremer.echobase.services.ImportDbService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Import
extends AbstractWaitAndExecAction<ImportDbConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Import.class);
    protected transient ImportDbService service;

    protected ImportDbConfiguration initModel() {
        return this.getEchoBaseSession().getImportDbConfiguration();
    }

    public void prepare() throws Exception {
        super.prepare();
        this.service = (ImportDbService)this.newService(ImportDbService.class);
    }

    protected void startAction(ImportDbConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports with file " + model.getInput().getFileName()));
        }
        this.service.importDb(model, this.getEchoBaseSession().getEchoBaseUser(), true);
    }

    protected void closeAction(ImportDbConfiguration model) throws Exception {
        model.destroy();
        this.getEchoBaseSession().setImportDbConfiguration(null);
    }
}

