/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.csv.CsvFileImportResult;
import fr.ifremer.echobase.services.ImportException;
import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.services.importdata.AbstractImportDataService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractLaunchImport<M extends AbstractImportConfiguration, S extends AbstractImportDataService<M>>
extends AbstractWaitAndExecAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);
    protected final Class<M> modelType;
    protected final Class<S> serviceType;
    protected transient S service;
    protected transient Exception error;
    protected List<CsvFileImportResult> result;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        this.modelType = modelType;
        this.serviceType = serviceType;
    }

    protected M initModel() {
        return (M)this.getEchoBaseSession().getImportDataConfiguration(this.modelType);
    }

    public List<CsvFileImportResult> getResult() {
        return this.result;
    }

    public Exception getError() {
        return this.error;
    }

    public void prepare() throws Exception {
        super.prepare();
        this.service = (AbstractImportDataService)this.newService(this.serviceType);
    }

    protected void startAction(M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports for " + this.getModel()));
        }
        try {
            this.result = this.service.doImport(model, this.getEchoBaseSession().getEchoBaseUser());
            this.addActionMessage(this._("echobase.info.import.succeded", new Object[0]));
        }
        catch (ImportException e) {
            this.addActionError(this._("echobase.info.import.failed", new Object[0]));
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while import ", (Throwable)e);
            }
            this.error = e;
        }
    }

    protected void closeAction(M model) throws Exception {
        model.destroy();
        this.getEchoBaseSession().removeImportDataConfiguration(this.modelType);
    }
}

