<%--
  #%L
  EchoBase :: UI
  
  $Id: configureAccousticData.jsp 369 2012-03-16 18:02:23Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureAccousticData.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<title>
  Configuration <s:text name="echobase.common.importDataMode.accousticData"/>
</title>

<script type="text/javascript">


  jQuery(document).ready(function () {

    $.autoSelectVoyageAndVessel(
      $('[name="model.voyageId"]'),
      $('[name="model.vesselId"]'),
      '<s:url action="getVesselsForVoyage" namespace="/importData"/>',
      '<s:property value="model.voyageId"/>',
      '<s:property value="model.vesselId"/>'
    );
  });
</script>

<s:form namespace="/importData" method="POST" enctype="multipart/form-data">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <sj:select key="model.vesselId" required="true"
               label='%{getText("echobase.common.vessel")}'/>

    <s:select key="model.cellPositionReference" required="true"
              label='%{getText("echobase.common.cellPositionReference")}'
              list="cellPositionReferences" headerKey="" headerValue=""/>

    <s:checkbox key="model.addDataAcquisition" required="true"
                label='%{getText("echobase.common.addDataAcquisition")}'/>

    <s:textfield key="model.transceiverAcquisitionAbsorptionDescription"
                 size="100" required="true"
                 label='%{getText("echobase.common.transceiverAcquisitionAbsorptionDescription")}'/>

    <s:textfield key="model.acquisitionSoftwareVersionER60" size="100"
                 required="true"
                 label='%{getText("echobase.common.acquisitionSoftwareVersionER60")}'/>

    <s:textfield key="model.acquisitionSoftwareVersionME70" size="100"
                 required="true"
                 label='%{getText("echobase.common.acquisitionSoftwareVersionME70")}'/>

    <s:textfield key="model.loggedDataFormat" size="100" required="true"
                 label='%{getText("echobase.common.loggedDataFormat")}'/>

    <s:textfield key="model.loggedDataDatatype" size="100" required="true"
                 label='%{getText("echobase.common.loggedDataDatatype")}'/>

    <s:textfield key="model.pingDutyCycle" size="100" required="true"
                 label='%{getText("echobase.common.pingDutyCycle")}'/>

    <%--<s:textfield key="model.echosounderSoundSpeed" size="100" required="true"--%>
                 <%--label='%{getText("echobase.common.echosounderSoundSpeed")}'/>--%>

    <s:textfield key="model.soundSpeedCalculationsER60" size="100"
                 required="true"
                 label='%{getText("echobase.common.soundSpeedCalculationsER60")}'/>

    <s:textfield key="model.soundSpeedCalculationsME70" size="100"
                 required="true"
                 label='%{getText("echobase.common.soundSpeedCalculationsME70")}'/>

    <s:textfield key="model.sounderConstant" size="100" required="true"
                 label='%{getText("echobase.common.sounderConstant")}'/>

    <s:textfield key="model.processingTemplate" size="100" required="true"
                 label='%{getText("echobase.common.processingTemplate")}'/>

    <s:textfield key="model.processingDescription" size="100" required="true"
                 label='%{getText("echobase.common.processingDescription")}'/>

    <s:textfield key="model.digitThreshold" size="100" required="true"
                 label='%{getText("echobase.common.digitThreshold")}'/>

    <s:textfield key="model.acousticDensityUnit" size="100" required="true"
                 label='%{getText("echobase.common.acousticDensityUnit")}'/>

    <s:textfield key="model.notes" size="100" required="true"
                 label='%{getText("echobase.common.notes")}'/>

    <s:file key="moviesFile" required="true"
            label='%{getText("echobase.common.moviesFile")}'/>

  </fieldset>
  <br/>
  <s:submit action="configureAccousticData" key='echobase.action.import'/>


</s:form>

