/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ExportTable.java 367 2012-03-16 11:57:15Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/ExportTable.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.ExportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * To export datas for the given request.
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class ExportTable extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImportTable.class);

    /** Type of entity to export. */
    protected EchoBaseEntityEnum entityType;

    /** Default file name to create. */
    protected String exportFileName;

    /** Stream of the file to export. */
    protected transient InputStream inputStream;

    /** Length of the file to export. */
    protected long contentLength;

    /** Type of the file to export. */
    protected String contentType;

    /** Export datas as seen on screen (no topiaId). */
    protected boolean exportAsSeen;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public void setExportAsSeen(boolean exportAsSeen) {
        this.exportAsSeen = exportAsSeen;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public long getContentLength() {
        return contentLength;
    }

    public String getContentType() {
        return contentType;
    }

    public String getExportFileName() {
        return exportFileName;
    }

    @Override
    public String execute() throws Exception {

        ExportService exportService = newService(ExportService.class);

        TableMeta table = serviceContext.getDbMeta().getTable(entityType);
        String content = exportService.exportDatas(table, exportAsSeen);

        if (log.isDebugEnabled()) {
            log.debug("file to export " + content);
        }
        //FIXME tchemit 2012-01-05 : use the double size to be sure to have the correct length :( find out which caracters are not unicode aware in baracouda datas
        contentLength = content.length() * 2;
        contentType = "text/csv";
        inputStream = new ByteArrayInputStream(content.getBytes());
        return SUCCESS;
    }
}
