/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.entities.references.MissionImpl;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.ImportDataService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.importData.SelectedMissionMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigureMission
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureMission.class);
    protected Map<String, String> missions;
    protected Map<String, String> importModes;
    protected SelectedMissionMode importMode;
    protected Mission mission;

    public Mission getMission() {
        if (this.mission == null) {
            this.mission = new MissionImpl();
        }
        return this.mission;
    }

    public Map<String, String> getImportModes() {
        return this.importModes;
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public SelectedMissionMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(SelectedMissionMode importMode) {
        this.importMode = importMode;
    }

    public String input() throws Exception {
        this.importModes = Maps.newLinkedHashMap();
        for (SelectedMissionMode mode : SelectedMissionMode.values()) {
            this.importModes.put(mode.name(), this._(mode.getI18nKey(), new Object[0]));
        }
        if (this.importMode == null) {
            this.importMode = SelectedMissionMode.USE_EXISTING_MISSION;
        }
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        List allMissions = service.getEntities(Mission.class);
        this.missions = this.sortAndDecorate((Collection)allMissions, null);
        if (log.isInfoEnabled()) {
            log.info((Object)("File errors : " + this.getFieldErrors()));
        }
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        if (this.importMode == SelectedMissionMode.CREATE_NEW_MISSION) {
            ImportDataService service = (ImportDataService)this.newService(ImportDataService.class);
            Mission missionToCreate = this.getMission();
            this.mission = service.createMission(missionToCreate);
        }
        return "success";
    }
}

