/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Import.java 238 2012-01-05 10:42:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/Import.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.services.CsvImportResult;
import fr.ifremer.echobase.services.configurations.ImportDataConfiguration;
import fr.ifremer.echobase.services.ImportDataService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;

/**
 * To launch the import data process.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Import extends EchoBaseActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Import.class);

    /** Import data configuration to push in session. */
    protected ImportDataConfiguration model;

    protected Map<InputFile, CsvImportResult> importResult;

    protected transient ImportDataService service;

    public ImportDataConfiguration getModel() {
        return model;
    }

    public Map<InputFile, CsvImportResult> getImportResult() {
        return importResult;
    }

    @Override
    public void prepare() throws Exception {

        model = getEchoBaseSession().getImportDataConfiguration();

        service = newService(ImportDataService.class);
    }

    @Override
    public String execute() throws Exception {

        try {
            if (log.isInfoEnabled()) {
                log.info("Start imports with mission " +
                         model.getMission().getName());
            }

            importResult = service.startImport(model);
            return SUCCESS;
        } finally {

            // clean configuration
            model.destroy();

            // remove configuration from session
            getEchoBaseSession().setImportDataConfiguration(null);
        }
    }
}
