/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CheckInUserSessionInterceptor.java 21 2011-11-08 09:03:06Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/interceptors/CheckInUserSessionInterceptor.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextParseUtil;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Collections;
import java.util.Set;

/**
 * To check if some data are in the user session.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see EchoBaseSession
 * @since 0.1
 */
public class CheckInUserSessionInterceptor extends AbstractCheckInterceptor {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    protected static final Log log =
            LogFactory.getLog(CheckInUserSessionInterceptor.class);

    private Set<String> parameters = Collections.emptySet();

    /**
     * Allows <code>sessionParametersToClean</code> attribute to be set as comma-separated-values (csv).
     *
     * @param parameters the sessionParametersToClean to set
     */
    public void setParameters(String parameters) {
        this.parameters =
                TextParseUtil.commaDelimitedStringToSet(parameters);
    }

    @Override
    protected boolean doCheck(ActionInvocation invocation) {
        EchoBaseActionSupport action = (EchoBaseActionSupport) invocation.getAction();

        EchoBaseSession echoBaseSession = action.getEchoBaseSession();
        Set<String> missingKeys = null;
        for (String parameter : parameters) {
            boolean ok = echoBaseSession.contains(parameter);
            if (!ok) {
                if (missingKeys == null) {
                    missingKeys = Sets.newHashSet();
                }
                missingKeys.add(parameter);
            }
        }
        if (CollectionUtils.isNotEmpty(missingKeys)) {
            // there is something missing in the user session
            String message = "Some objects were not found in session : " +
                             missingKeys + ", " + "redirect to " + redirectAction;
            if (log.isInfoEnabled()) {
                log.info(message);
            }
            return false;
        }
        return true;
    }

}
