/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.EchoBaseUserDTO;
import fr.ifremer.echobase.entities.EchoBaseUserDTOImpl;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.EditActionEnum;
import fr.ifremer.echobase.ui.actions.user.ManageUser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageUser
extends EchoBaseActionSupport
implements Preparable {
    protected static final Log log = LogFactory.getLog(ManageUser.class);
    private static final long serialVersionUID = 1L;
    public static final String BACK_TO_LIST = "backToList";
    protected transient UserService service;
    protected EchoBaseUserDTO user;
    protected String userEditAction;

    public String getUserEditAction() {
        return this.userEditAction;
    }

    public void setUserEditAction(String userEditAction) {
        this.userEditAction = userEditAction;
    }

    protected UserService getUserService() {
        if (this.service == null) {
            this.service = (UserService)this.newService(UserService.class);
        }
        return this.service;
    }

    public void prepare() throws Exception {
        String userId = this.getUser().getId();
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            this.user = this.getUserService().getUserById(userId).toDTO();
            log.info((Object)("Selected user " + this.user.getEmail()));
        }
    }

    public String doCreateOrUpdate() throws Exception {
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will create user  " + userEmail));
        }
        this.getUserService().createOrUpdate(user);
        return BACK_TO_LIST;
    }

    public String doDelete() throws Exception {
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will delete user " + userEmail));
        }
        this.getUserService().delete(user);
        return BACK_TO_LIST;
    }

    public void validate() {
        EditActionEnum action = this.getEditActionEnum();
        log.info((Object)("Edit action : " + action));
        if (action == null) {
            return;
        }
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        switch (1.$SwitchMap$fr$ifremer$echobase$ui$actions$EditActionEnum[action.ordinal()]) {
            case 1: {
                if (StringUtils.isEmpty((CharSequence)userEmail)) {
                    this.addFieldError("user.email", this._("echobase.error.required.email", new Object[0]));
                } else {
                    EchoBaseUser login;
                    try {
                        login = this.getUserService().getUserByEmail(userEmail);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not obtain user " + userEmail, e);
                    }
                    if (login != null) {
                        this.addFieldError("user.email", this._("echobase.error.email.already.used", new Object[0]));
                    }
                }
                String userPassword = user.getPassword();
                if (!StringUtils.isEmpty((CharSequence)userPassword)) break;
                this.addFieldError("user.password", this._("echobase.error.required.password", new Object[0]));
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public EchoBaseUserDTO getUser() {
        if (this.user == null) {
            this.user = new EchoBaseUserDTOImpl();
        }
        return this.user;
    }

    protected EditActionEnum getEditActionEnum() {
        if (this.userEditAction == null) {
            return null;
        }
        return EditActionEnum.valueOf((String)this.userEditAction);
    }
}

