/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;
import org.nuiton.util.beans.PropertyDiff;

public class SaveEntity
extends EchoBaseActionSupport
implements ParameterAware {
    private static final long serialVersionUID = 1L;
    protected String tableName;
    protected String id;
    protected TableMeta tableMeta;
    protected Map<String, String[]> params;

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() throws Exception {
        PropertyDiff[] diffs;
        DbEditorService dbEditorService = (DbEditorService)this.newService(DbEditorService.class);
        TableMeta tableMeta = dbEditorService.getTableMetas(this.tableName);
        HashMap properties = Maps.newHashMap();
        List columnNames = tableMeta.getColumnNames();
        for (String columnName : columnNames) {
            String propertyValue;
            String[] values;
            if (!this.params.containsKey(columnName) || (values = (String[])this.params.get(columnName)).length <= 0 || !StringUtils.isNotEmpty((CharSequence)(propertyValue = values[0]))) continue;
            properties.put(columnName, propertyValue);
        }
        for (PropertyDiff diff : diffs = dbEditorService.saveEntity(tableMeta, this.id, (Map)properties, this.getEchoBaseSession().getEchoBaseUser())) {
            this.addActionMessage(this._("echobase.message.modified.property", new Object[]{diff.getSourceProperty(), diff.getSourceValue(), diff.getTargetValue()}));
        }
        return "none";
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.params = Maps.newHashMap();
        this.params.putAll(parameters);
    }
}

