/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import org.nustaq.serialization.util.FSTUtil;

public class FSTObject2IntMap<K> {
    static int[] prim = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 37, 67, 97, 139, 211, 331, 641, 1097, 1531, 2207, 3121, 5059, 7607, 10891, 15901, 19993, 30223, 50077, 74231, 99991, 150001, 300017, 1000033, 1500041, 200033, 3000077, 5000077, 10000019};
    private static final int GROFAC = 2;
    public Object[] mKeys;
    public int[] mValues;
    public int mNumberOfElements;
    FSTObject2IntMap<K> next;
    boolean checkClazzOnEquals = false;
    static int miss = 0;
    static int hit = 0;

    public static int adjustSize(int size) {
        for (int i = 0; i < prim.length - 1; ++i) {
            if (size >= prim[i]) continue;
            return prim[i];
        }
        return size;
    }

    public FSTObject2IntMap(int initialSize, boolean checkClassOnequals) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new Object[initialSize];
        this.mValues = new int[initialSize];
        this.mNumberOfElements = 0;
        this.checkClazzOnEquals = checkClassOnequals;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(K key, int value) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        this.putHash(key, value, hash, this);
    }

    private static final <K> void putHash(K key, int value, int hash, FSTObject2IntMap<K> current, FSTObject2IntMap<K> parent, boolean checkClazzOnEquals) {
        int count = 0;
        while (true) {
            int idx;
            if (current.mNumberOfElements * 2 > current.mKeys.length) {
                if (parent != null) {
                    if ((parent.mNumberOfElements + current.mNumberOfElements) * 2 > parent.mKeys.length) {
                        parent.resize(parent.mKeys.length * 2);
                        parent.put(key, value);
                        return;
                    }
                    current.resize(current.mKeys.length * 2);
                } else {
                    current.resize(current.mKeys.length * 2);
                }
            }
            if (current.mKeys[idx = hash % current.mKeys.length] == null) {
                ++current.mNumberOfElements;
                current.mValues[idx] = value;
                current.mKeys[idx] = key;
                return;
            }
            if (!(current.mKeys[idx] != key || checkClazzOnEquals && current.mKeys[idx].getClass() != key.getClass())) {
                current.mValues[idx] = value;
                return;
            }
            if (current.next == null) {
                int newSiz;
                if (count > 4 && current.mNumberOfElements < 5) {
                    newSiz = current.mNumberOfElements * 2 + 1;
                    current.next = new FSTObject2IntMap<K>(newSiz, checkClazzOnEquals);
                    count = 0;
                } else {
                    newSiz = current.mNumberOfElements / 3;
                    current.next = new FSTObject2IntMap<K>(newSiz, checkClazzOnEquals);
                }
            }
            parent = current;
            current = current.next;
            ++count;
        }
    }

    final void putHash(K key, int value, int hash, FSTObject2IntMap<K> parent) {
        FSTObject2IntMap.putHash(key, value, hash, this, parent, this.checkClazzOnEquals);
    }

    final K removeHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mKey = this.mKeys[idx];
        if (mKey == null) {
            return null;
        }
        if (mKey.equals(key) && (!this.checkClazzOnEquals || this.mKeys[idx].getClass() == key.getClass())) {
            Object val = this.mKeys[idx];
            this.mValues[idx] = 0;
            this.mKeys[idx] = null;
            --this.mNumberOfElements;
            return (K)val;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.removeHash(key, hash);
    }

    final void putNext(int hash, K key, int value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTObject2IntMap<K>(newSiz, this.checkClazzOnEquals);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final int get(K key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return this.mValues[idx];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        int res = this.next.getHash(key, hash);
        return res;
    }

    final int getHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return this.mValues[idx];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        int res = this.next.getHash(key, hash);
        return res;
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        Object[] oldTabKey = this.mKeys;
        int[] oldTabVal = this.mValues;
        this.mKeys = new Object[newSize];
        this.mValues = new int[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTObject2IntMap<K> oldNext = this.next;
            this.next = null;
            oldNext.rePut(this);
        }
    }

    private void rePut(FSTObject2IntMap<K> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            Object mKey = this.mKeys[i];
            if (mKey == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            this.next.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }
}

