/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.maven.plugin.offline;

import de.qaware.maven.plugin.offline.ArtifactWithRepoType;
import de.qaware.maven.plugin.offline.DynamicDependency;
import de.qaware.maven.plugin.offline.ReactorArtifact;
import de.qaware.maven.plugin.offline.RepositoryType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;

@Component(role=DependencyDownloader.class, hint="default")
public class DependencyDownloader {
    private static final String MAVEN_PLUGIN_ARTIFACT_TYPE = "maven-plugin";
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    private DefaultRepositorySystemSession remoteSession;
    private DefaultRepositorySystemSession pluginSession;
    private List<RemoteRepository> remoteRepositories;
    private List<RemoteRepository> pluginRepositories;
    private ArtifactTypeRegistry typeRegistry;
    private Log log;
    private List<Exception> errors;
    private boolean downloadSources = false;
    private boolean downloadJavadoc = false;
    private Set<ReactorArtifact> reactorArtifacts;

    public void init(ProjectBuildingRequest buildingRequest, List<MavenProject> reactorProjects, Log logger) {
        this.log = logger;
        this.typeRegistry = RepositoryUtils.newArtifactTypeRegistry((ArtifactHandlerManager)this.artifactHandlerManager);
        this.remoteRepositories = RepositoryUtils.toRepos((List)buildingRequest.getRemoteRepositories());
        this.pluginRepositories = RepositoryUtils.toRepos((List)buildingRequest.getPluginArtifactRepositories());
        this.remoteSession = new DefaultRepositorySystemSession(buildingRequest.getRepositorySession());
        DependencySelector wagonExcluder = null;
        try {
            Class<?> wagonExcluderClass = Class.forName("org.apache.maven.plugin.internal.WagonExcluder");
            Constructor<?> wagonExcluderConstructor = wagonExcluderClass.getDeclaredConstructor(new Class[0]);
            wagonExcluderConstructor.setAccessible(true);
            wagonExcluder = (DependencySelector)wagonExcluderConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.log.warn((CharSequence)"Could not initialize wagonExcluder, might not be able to download plugin dependencies correctly", (Throwable)e);
        }
        this.reactorArtifacts = this.computeReactorArtifacts(reactorProjects);
        AndDependencySelector selector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"system", "test", "provided"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        this.remoteSession.setDependencySelector((DependencySelector)selector);
        this.pluginSession = new DefaultRepositorySystemSession((RepositorySystemSession)this.remoteSession);
        this.remoteSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        this.pluginSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        if (wagonExcluder != null) {
            this.pluginSession.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"system", "test", "provided"}), new OptionalDependencySelector(), wagonExcluder, new ExclusionDependencySelector()}));
        }
        this.errors = new ArrayList<Exception>();
    }

    public void enableDownloadSources() {
        this.downloadSources = true;
    }

    public void enableDownloadJavadoc() {
        this.downloadJavadoc = true;
    }

    public void downloadArtifacts(Collection<ArtifactWithRepoType> artifacts) {
        ArrayList<ArtifactRequest> mainRequests = new ArrayList<ArtifactRequest>(artifacts.size());
        ArrayList<ArtifactRequest> pluginRequests = new ArrayList<ArtifactRequest>(artifacts.size());
        for (ArtifactWithRepoType artifactWithRepoType : artifacts) {
            org.eclipse.aether.artifact.Artifact artifact = artifactWithRepoType.getArtifact();
            RepositoryType context = artifactWithRepoType.getRepositoryType();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(artifact);
            artifactRequest.setRepositories(context == RepositoryType.MAIN ? this.remoteRepositories : this.pluginRepositories);
            if (context == RepositoryType.MAIN) {
                artifactRequest.setRequestContext(context.getRequestContext());
                mainRequests.add(artifactRequest);
            } else {
                artifactRequest.setRequestContext(context.getRequestContext());
                pluginRequests.add(artifactRequest);
            }
            if (context != RepositoryType.MAIN || !"jar".equals(artifact.getExtension())) continue;
            if (this.downloadSources) {
                DefaultArtifact sourceArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "sources", artifact.getExtension(), artifact.getVersion());
                mainRequests.add(new ArtifactRequest((org.eclipse.aether.artifact.Artifact)sourceArtifact, this.remoteRepositories, context.getRequestContext()));
            }
            if (!this.downloadJavadoc) continue;
            DefaultArtifact javadocArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "javadoc", artifact.getExtension(), artifact.getVersion());
            mainRequests.add(new ArtifactRequest((org.eclipse.aether.artifact.Artifact)javadocArtifact, this.remoteRepositories, context.getRequestContext()));
        }
        try {
            this.repositorySystem.resolveArtifacts((RepositorySystemSession)this.remoteSession, mainRequests);
        }
        catch (RuntimeException | ArtifactResolutionException e) {
            this.log.error((CharSequence)"Error downloading dependencies for project");
            this.handleRepositoryException((Exception)e);
        }
        try {
            this.repositorySystem.resolveArtifacts((RepositorySystemSession)this.pluginSession, pluginRequests);
        }
        catch (RuntimeException | ArtifactResolutionException e) {
            this.log.error((CharSequence)"Error downloading plugin dependencies for project");
            this.handleRepositoryException((Exception)e);
        }
    }

    public Set<ArtifactWithRepoType> resolveDependencies(MavenProject project) {
        org.eclipse.aether.artifact.Artifact projectArtifact = RepositoryUtils.toArtifact((Artifact)project.getArtifact());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(this.remoteRepositories);
        collectRequest.setRootArtifact(projectArtifact);
        collectRequest.setRequestContext(RepositoryType.MAIN.getRequestContext());
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency d : project.getDependencies()) {
            Dependency dependency = RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)this.typeRegistry);
            aetherDependencies.add(dependency);
        }
        collectRequest.setDependencies(aetherDependencies);
        ArrayList<Dependency> aetherDepManagement = new ArrayList<Dependency>();
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            for (org.apache.maven.model.Dependency d : dependencyManagement.getDependencies()) {
                Dependency dependency = RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)this.typeRegistry);
                aetherDepManagement.add(dependency);
            }
        }
        collectRequest.setManagedDependencies(aetherDepManagement);
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)this.remoteSession, collectRequest);
            return this.getArtifactsFromCollectResult(collectResult, RepositoryType.MAIN);
        }
        catch (RuntimeException | RepositoryException e) {
            this.log.error((CharSequence)("Error resolving dependencies for project " + project.getGroupId() + ":" + project.getArtifactId()));
            this.handleRepositoryException((Exception)e);
            return Collections.emptySet();
        }
    }

    private Set<ArtifactWithRepoType> getArtifactsFromCollectResult(CollectResult collectResult, RepositoryType context) {
        CollectAllDependenciesVisitor visitor = new CollectAllDependenciesVisitor();
        collectResult.getRoot().accept((DependencyVisitor)visitor);
        Set<org.eclipse.aether.artifact.Artifact> visitorArtifacts = visitor.getArtifacts();
        HashSet<ArtifactWithRepoType> artifacts = new HashSet<ArtifactWithRepoType>();
        for (org.eclipse.aether.artifact.Artifact visitorArtifact : visitorArtifacts) {
            if (this.isReactorArtifact(visitorArtifact)) continue;
            artifacts.add(new ArtifactWithRepoType(visitorArtifact, context));
        }
        org.eclipse.aether.artifact.Artifact rootArtifact = collectResult.getRoot().getArtifact();
        if (!this.isReactorArtifact(rootArtifact)) {
            artifacts.add(new ArtifactWithRepoType(rootArtifact, context));
        }
        return artifacts;
    }

    public Set<ArtifactWithRepoType> resolvePlugin(Plugin plugin) {
        org.eclipse.aether.artifact.Artifact pluginArtifact = this.toArtifact(plugin);
        Dependency pluginDependency = new Dependency(pluginArtifact, null);
        CollectRequest collectRequest = new CollectRequest(pluginDependency, this.pluginRepositories);
        collectRequest.setRequestContext(RepositoryType.PLUGIN.getRequestContext());
        ArrayList<Dependency> pluginDependencies = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency d : plugin.getDependencies()) {
            Dependency dependency = RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)this.typeRegistry);
            pluginDependencies.add(dependency);
        }
        collectRequest.setDependencies(pluginDependencies);
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)this.pluginSession, collectRequest);
            return this.getArtifactsFromCollectResult(collectResult, RepositoryType.PLUGIN);
        }
        catch (RuntimeException | DependencyCollectionException e) {
            this.log.error((CharSequence)("Error resolving plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId()));
            this.handleRepositoryException((Exception)e);
            return Collections.emptySet();
        }
    }

    public Set<ArtifactWithRepoType> resolveDynamicDependency(DynamicDependency dynamicDependency) {
        DefaultRepositorySystemSession session;
        ArtifactType artifactType = this.typeRegistry.get(dynamicDependency.getType());
        DefaultArtifact artifact = artifactType == null ? new DefaultArtifact(dynamicDependency.getGroupId(), dynamicDependency.getArtifactId(), dynamicDependency.getClassifier(), dynamicDependency.getType(), dynamicDependency.getVersion()) : new DefaultArtifact(dynamicDependency.getGroupId(), dynamicDependency.getArtifactId(), dynamicDependency.getClassifier(), artifactType.getExtension(), dynamicDependency.getVersion(), artifactType);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((org.eclipse.aether.artifact.Artifact)artifact, null));
        RepositoryType repositoryType = dynamicDependency.getRepositoryType();
        switch (repositoryType) {
            case MAIN: {
                session = this.remoteSession;
                collectRequest.setRepositories(this.remoteRepositories);
                collectRequest.setRequestContext(repositoryType.getRequestContext());
                break;
            }
            case PLUGIN: {
                session = this.pluginSession;
                collectRequest.setRepositories(this.pluginRepositories);
                collectRequest.setRequestContext(repositoryType.getRequestContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown enum val " + (Object)((Object)repositoryType));
            }
        }
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            return this.getArtifactsFromCollectResult(collectResult, repositoryType);
        }
        catch (RuntimeException | DependencyCollectionException e) {
            this.log.error((CharSequence)("Error resolving dynamic dependency" + dynamicDependency.getGroupId() + ":" + dynamicDependency.getArtifactId()));
            this.handleRepositoryException((Exception)e);
            return Collections.emptySet();
        }
    }

    public List<Exception> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    private Set<ReactorArtifact> computeReactorArtifacts(List<MavenProject> reactorProjects) {
        HashSet<ReactorArtifact> artifacts = new HashSet<ReactorArtifact>(reactorProjects.size());
        for (MavenProject p : reactorProjects) {
            artifacts.add(new ReactorArtifact(p.getArtifact()));
        }
        return artifacts;
    }

    private boolean isReactorArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        return this.reactorArtifacts.contains(new ReactorArtifact(artifact));
    }

    private void handleRepositoryException(Exception e) {
        this.log.error((CharSequence)e.getMessage());
        this.log.debug((Throwable)e);
        this.addToErrorList(e);
    }

    private synchronized void addToErrorList(Exception e) {
        this.errors.add(e);
    }

    private org.eclipse.aether.artifact.Artifact toArtifact(Plugin plugin) {
        ArtifactType artifactType = this.typeRegistry.get(MAVEN_PLUGIN_ARTIFACT_TYPE);
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), artifactType.getClassifier(), artifactType.getExtension(), plugin.getVersion(), artifactType);
    }

    private static class CollectAllDependenciesVisitor
    implements DependencyVisitor {
        private boolean root = true;
        private Set<org.eclipse.aether.artifact.Artifact> artifacts = new HashSet<org.eclipse.aether.artifact.Artifact>();

        private CollectAllDependenciesVisitor() {
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.root) {
                this.root = false;
                return true;
            }
            return this.artifacts.add(node.getArtifact());
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        public Set<org.eclipse.aether.artifact.Artifact> getArtifacts() {
            return this.artifacts;
        }
    }
}

