package de.intarsys.pdf.platform.cwt.image.awt;

import java.io.IOException;
import java.io.InputStream;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;

public class PlatformImageTools {

	public static boolean matchColorSpace(PDImage pdImage, String colorSpaceType) {
		PDColorSpace colorSpace;

		colorSpace = pdImage.getColorSpace();
		/*
		 * actually there's a chance Indexed and ICCBased do not reflect the
		 * expected color range but I've yet to come across a case where that
		 * matters
		 */
		if ("GRAY".equals(colorSpaceType)
				&& (colorSpace == PDCSDeviceGray.SINGLETON
						|| (colorSpace instanceof PDCSIndexed) || (colorSpace instanceof PDCSICCBased && (AwtColorSpaceFactory
						.get().createColorSpace(colorSpace).getNumComponents() == 1)))) {
			return true;
		}
		if (("RGB".equals(colorSpaceType) || "YCbCr".equals(colorSpaceType))
				&& (pdImage.getColorSpace() == PDCSDeviceRGB.SINGLETON || (colorSpace instanceof PDCSICCBased && (AwtColorSpaceFactory
						.get().createColorSpace(colorSpace).getNumComponents() == 3)))) {
			return true;
		}
		return false;
	}

	public static boolean matchColorSpaceType(PDImage pdImage,
			InputStream stream) throws IOException {
		String colorSpaceType;

		if (pdImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
			// cannot find out; assume "yes"
			return true;
		}
		try {
			colorSpaceType = ImageTools.extractJPEGColorSpaceType(stream);
		} catch (ImageException ex) {
			/*
			 * if color space cannot be extracted assume YCbCr and try decoding;
			 * might fail later
			 */
			colorSpaceType = "YCbCr"; //$NON-NLS-1$
		}
		return matchColorSpace(pdImage, colorSpaceType);
	}
}
