/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import java.awt.image.BufferedImage;

import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.ImageEntry;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.adapter.awt.AwtGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;

public class PDImageEntry extends ImageEntry implements IAwtImage {

	private int index;
	private PDImage pdImage;

	/**
	 * @param container
	 */
	public PDImageEntry(IImageContainer container, PDImage pdImage) {
		super(container);
		this.pdImage = pdImage;
	}

	public void drawFromGraphicsContext(IGraphicsContext graphicsContext,
			float x, float y) {
		getDelegate().drawFromGraphicsContext(graphicsContext, x, y);
	}

	public BufferedImage getBufferedImage() {
		return AwtGraphicsEnvironmentAdapter.get().createImage(pdImage);
	}

	@Override
	synchronized protected IImage getErrorImage(Exception e) {
		return null;
	}

	public int getIndex() {
		return index;
	}

	@Override
	protected IImage loadContent() {
		return new CwtPlatformImage(pdImage);
	}
}
