/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.swt;

import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDCSCalRGB;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.tools.attribute.Attribute;

/**
 * 
 */
public class SwtColorSpaceFactory {

	private static final Attribute ATTR_COLORSPACE = new Attribute(
			"swtColorspace");

	private static SwtColorSpaceFactory Unique = new SwtColorSpaceFactory();

	synchronized static public SwtColorSpaceFactory get() {
		return Unique;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.intarsys.pdf.rendering.tools.IPlatformColorSpaceFactory#createPlatformColorSpace(de.intarsys.pdf.pd.PDColorSpace)
	 */
	public SwtColorSpace createPlatformColorSpace(PDColorSpace pdColorSpace) {
		SwtColorSpace result = (SwtColorSpace) pdColorSpace
				.getAttribute(ATTR_COLORSPACE);
		if (result == null) {
			if (pdColorSpace instanceof PDCSCalGray) {
				result = new SwtCSCalGray(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSCalRGB) {
				result = new SwtCSCalRGB(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSICCBased) {
				result = new SwtCSICCBased(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSLab) {
				result = new SwtCSLab(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSDeviceCMYK) {
				result = new SwtCSDeviceCMYK(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSDeviceGray) {
				result = new SwtCSDeviceGray(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSDeviceRGB) {
				result = new SwtCSDeviceRGB(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSDeviceN) {
				result = new SwtCSDeviceN(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSIndexed) {
				result = new SwtCSIndexed(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSPattern) {
				result = new SwtCSPattern(pdColorSpace);
			} else if (pdColorSpace instanceof PDCSSeparation) {
				result = new SwtCSSeparation(pdColorSpace);
			} else {
				result = new SwtCSDeviceRGB(pdColorSpace);
			}
			pdColorSpace.setAttribute(ATTR_COLORSPACE, result);
		}
		return result;
	}
}
