/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.InputStream;

import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDColorSpace;

/**
 * 
 */
public class AwtCSDeviceCMYK extends AwtCSDevice {
	public AwtCSDeviceCMYK(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		try {
			InputStream stream;
			ICC_Profile profile;

			stream = getClass().getResourceAsStream("DeviceCMYK.icc"); //$NON-NLS-1$
			if (stream == null) {
				return null;
			}
			try {
				profile = ICC_Profile.getInstance(stream);
			} finally {
				stream.close();
			}
			return new ICC_ColorSpace(profile);
		} catch (Exception e) {
			return null;
		}
	}

	@Override
	public int getNumComponents() {
		return 4;
	}

	protected PDCSDeviceCMYK myPDColorSpace() {
		return (PDCSDeviceCMYK) getPDColorSpace();
	}

}
