/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.DataStrategy;
import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDataStrategy<E>
implements DataStrategy<E> {
    public static final long DATA_LENGTH_SIZE = 4L;
    public static final long INDEX_SIZE = 8L;
    private boolean supportingOverwrite;

    public SparseDataStrategy() {
        this(true);
    }

    public SparseDataStrategy(boolean supportingOverwrite) {
        this.supportingOverwrite = supportingOverwrite;
    }

    public boolean isSupportingOverwrite() {
        return this.supportingOverwrite;
    }

    public void setSupportingOverwrite(boolean supportingOverwrite) {
        this.supportingOverwrite = supportingOverwrite;
    }

    @Override
    public void add(E element, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException {
        long elementsCount = indexStrategy.getSize(indexFile);
        long offset = dataFile.length();
        this.internalWriteElement(dataFile, offset, elementsCount, element, codec);
        indexStrategy.setOffset(indexFile, elementsCount, offset);
    }

    @Override
    public void addAll(List<E> elements, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException {
        int newElementCount;
        if (elements != null && (newElementCount = elements.size()) > 0) {
            long elementsCount = indexStrategy.getSize(indexFile);
            long offset = dataFile.length();
            long[] offsets = new long[newElementCount];
            int index = 0;
            for (E element : elements) {
                offsets[index] = offset;
                offset = offset + (long)this.internalWriteElement(dataFile, offset, elementsCount + (long)index, element, codec) + 4L + 8L;
                ++index;
            }
            index = 0;
            for (long curOffset : offsets) {
                indexStrategy.setOffset(indexFile, elementsCount + (long)index, curOffset);
                ++index;
            }
        }
    }

    @Override
    public boolean set(long index, E element, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException, UnsupportedOperationException {
        long offset = indexStrategy.getOffset(indexFile, index);
        if (!this.supportingOverwrite && offset >= 0L) {
            return false;
        }
        if (element != null) {
            offset = dataFile.length();
            this.internalWriteElement(dataFile, offset, index, element, codec);
            indexStrategy.setOffset(indexFile, index, offset);
            return true;
        }
        indexStrategy.setOffset(indexFile, index, -1L);
        return true;
    }

    @Override
    public boolean isSetSupported() {
        return true;
    }

    @Override
    public E get(long index, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException, ClassNotFoundException {
        long elementsCount = indexStrategy.getSize(indexFile);
        if (index >= 0L && index < elementsCount) {
            long offset = indexStrategy.getOffset(indexFile, index);
            if (offset < 0L) {
                return null;
            }
            return this.internalReadElement(dataFile, offset, codec);
        }
        return null;
    }

    private int internalWriteElement(RandomAccessFile dataFile, long offset, long index, E element, Codec<E> codec) throws IOException {
        if (codec == null) {
            throw new IllegalStateException("Codec has not been initialized!");
        }
        byte[] buffer = codec.encode(element);
        int bufferSize = buffer.length;
        dataFile.seek(offset);
        dataFile.writeInt(bufferSize);
        dataFile.writeLong(index);
        dataFile.write(buffer);
        return bufferSize;
    }

    private E internalReadElement(RandomAccessFile dataFile, long offset, Codec<E> codec) throws IOException, ClassNotFoundException, ClassCastException {
        if (codec == null) {
            throw new IllegalStateException("Codec has not been initialized!");
        }
        if (dataFile.length() < offset + 4L + 8L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + offset + "! Couldn't read length of data!");
        }
        dataFile.seek(offset);
        int bufferSize = dataFile.readInt();
        long startOfData = offset + 4L + 8L;
        if (dataFile.length() < startOfData + (long)bufferSize) {
            throw new IndexOutOfBoundsException("Invalid length (" + bufferSize + ") at offset: " + offset + "!");
        }
        dataFile.seek(startOfData);
        byte[] buffer = new byte[bufferSize];
        dataFile.readFully(buffer);
        return (E)codec.decode(buffer);
    }
}

