/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.springnative;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.vaadin.flow.router.MenuData;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.hilla.OpenAPIUtil;
import com.vaadin.hilla.push.PushEndpoint;
import com.vaadin.hilla.push.messages.fromclient.AbstractServerMessage;
import com.vaadin.hilla.push.messages.toclient.AbstractClientMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

public class HillaHintsRegistrar
implements RuntimeHintsRegistrar {
    private static final String openApiResourceName = "/hilla-openapi.json";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerEndpointTypes(hints);
        hints.resources().registerPattern("file-routes.json");
        hints.reflection().registerType(MenuData.class, MemberCategory.values());
        hints.reflection().registerType(AvailableViewInfo.class, MemberCategory.values());
        hints.reflection().registerType(PushEndpoint.class, MemberCategory.values());
        ArrayList pushMessageTypes = new ArrayList();
        pushMessageTypes.addAll(this.getMessageTypes(AbstractServerMessage.class));
        pushMessageTypes.addAll(this.getMessageTypes(AbstractClientMessage.class));
        for (Class clazz : pushMessageTypes) {
            hints.reflection().registerType(clazz, MemberCategory.values());
        }
    }

    private void registerEndpointTypes(RuntimeHints hints) {
        try {
            URL resource = this.getClass().getResource(openApiResourceName);
            if (resource == null) {
                this.logger.error("Resource {} is not available", (Object)openApiResourceName);
                return;
            }
            this.logger.info("Resource {} is being used for registering endpoint types", (Object)openApiResourceName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            String openApiAsText = reader.lines().collect(Collectors.joining("\n"));
            Set<String> types = OpenAPIUtil.findOpenApiClasses(openApiAsText);
            for (String type : types) {
                hints.reflection().registerType(TypeReference.of((String)type), MemberCategory.values());
            }
        }
        catch (IOException e) {
            this.logger.error("Error while scanning and registering endpoint types", (Throwable)e);
        }
        hints.resources().registerPattern("hilla-openapi.json");
    }

    private Collection<Class<?>> getMessageTypes(Class<?> cls) {
        ArrayList classes = new ArrayList();
        classes.add(cls);
        JsonSubTypes subTypes = cls.getAnnotation(JsonSubTypes.class);
        for (JsonSubTypes.Type t : subTypes.value()) {
            classes.add(t.value());
        }
        return classes;
    }
}

