/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;

public class VaadinServletResponse
extends HttpServletResponseWrapper
implements VaadinResponse {
    private VaadinServletService vaadinService;

    public VaadinServletResponse(HttpServletResponse response, VaadinServletService vaadinService) {
        super(response);
        this.vaadinService = vaadinService;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this;
    }

    @Override
    public void setCacheTime(long milliseconds) {
        VaadinServletResponse.doSetCacheTime(this, milliseconds);
    }

    private static void doSetCacheTime(VaadinResponse response, long milliseconds) {
        if (milliseconds <= 0L) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        } else {
            response.setHeader("Cache-Control", "max-age=" + milliseconds / 1000L);
            response.setDateHeader("Expires", System.currentTimeMillis() + milliseconds);
            response.setHeader("Pragma", "cache");
        }
    }

    @Override
    public VaadinServletService getService() {
        return this.vaadinService;
    }

    public static VaadinServletResponse getCurrent() {
        VaadinResponse currentResponse = VaadinResponse.getCurrent();
        if (currentResponse instanceof VaadinServletResponse) {
            return (VaadinServletResponse)currentResponse;
        }
        return null;
    }
}

