/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class AbstractThreadPool
extends AbstractExecutorService
implements ExtendedThreadPool,
Thread.UncaughtExceptionHandler {
    public static int DEFAULT_MIN_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    public static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected static final Runnable poison = new Runnable(){

        public void run() {
        }
    };
    protected volatile int initialByteBufferSize = 8192;
    protected volatile ByteBufferFactory.ByteBufferType byteBufferType = WorkerThreadImpl.DEFAULT_BYTEBUFFER_TYPE;
    protected volatile String name = "GrizzlyWorker";
    protected volatile int priority = 5;
    protected volatile int corePoolSize;
    protected volatile int maxPoolSize;
    protected volatile long keepAliveTime;
    protected volatile ThreadFactory threadFactory;

    protected abstract String nextThreadId();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maxPoolSize = maximumPoolSize;
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.keepAliveTime = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public void setInitialByteBufferSize(int initialByteBufferSize) {
        this.initialByteBufferSize = initialByteBufferSize;
    }

    protected void validateNewPoolSize(int corePoolsize, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolsize < 1");
        }
        if (corePoolsize < 1) {
            throw new IllegalArgumentException("corePoolsize < 1");
        }
        if (corePoolsize > maxPoolSize) {
            throw new IllegalArgumentException("corePoolsize > maxPoolSize");
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void onWorkerStarted(Worker worker) {
    }

    protected void onWorkerExit(Worker worker) {
    }

    protected void onMaxNumberOfThreadsReached() {
    }

    protected void onTaskQueued(Runnable task) {
    }

    protected void onTaskDequeued(Runnable task) {
    }

    protected void onTaskQueueOverflow() {
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        LoggerUtils.getLogger().log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    public abstract class Worker
    implements Runnable {
        protected Thread t;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractThreadPool.this.onWorkerStarted(this);
            try {
                this.doWork();
            }
            finally {
                AbstractThreadPool.this.onWorkerExit(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void doWork() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        error = null;
                        Thread.interrupted();
                        r = this.getTask();
                        if (r == AbstractThreadPool.poison || r == null) {
                            return;
                        }
                        AbstractThreadPool.this.onTaskDequeued(r);
                        AbstractThreadPool.this.beforeExecute(this.t, r);
                        try {
                            r.run();
                        }
                        catch (Throwable throwable) {
                            error = throwable;
                        }
                        finally {
                            AbstractThreadPool.this.afterExecute(r, error);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var2_3) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        protected abstract Runnable getTask() throws InterruptedException;
    }
}

