/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Context;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.http.ThreadPoolStatistic;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class SelectorThreadHandler
extends TCPSelectorHandler {
    private SelectorThread selectorThread;

    public SelectorThreadHandler() {
    }

    public SelectorThreadHandler(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        SelectorThreadHandler copyHandler = (SelectorThreadHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    public void setSelectorThread(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public void configureChannel(SelectableChannel channel) throws IOException {
        if (channel instanceof SocketChannel) {
            this.selectorThread.setSocketOptions(((SocketChannel)channel).socket());
        }
        super.configureChannel(channel);
    }

    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (channel != null) {
            this.configureChannel(channel);
            SelectionKey readKey = channel.register(this.selector, 1);
            readKey.attach(System.currentTimeMillis());
            if (this.selectorThread.getThreadPool() instanceof StatsThreadPool) {
                this.selectorThread.getRequestGroupInfo().increaseCountOpenConnections();
                ThreadPoolStatistic tps = ((StatsThreadPool)this.selectorThread.getThreadPool()).getStatistic();
                if (tps != null) {
                    tps.incrementTotalAcceptCount();
                    tps.incrementOpenConnectionsCount(readKey.channel());
                }
            }
        }
        return false;
    }
}

